/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.refactoring.core.rename.AbstractRenameRefactoringTest;
import org.eclipse.php.refactoring.core.rename.RenameClassMemberProcessor;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameClassMemberProcessorTest0027555
extends AbstractRenameRefactoringTest {
    private IProject project1;
    private IFile file;
    private IFile file1;

    @Before
    public void setUp() throws Exception {
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("project1");
        IFolder folder = this.project1.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.file = folder.getFile("test0027555.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php $a = new A(); $a->foo();".getBytes());
        if (!this.file.exists()) {
            this.file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        this.file1 = folder.getFile("test0027555_1.php");
        source = new ByteArrayInputStream("<?php class A {function foo(){}}".getBytes());
        if (!this.file1.exists()) {
            this.file1.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file1.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    @Test
    public void testRename1() throws Exception {
        Program program = this.createProgram(this.file1);
        Assert.assertNotNull((Object)program);
        int start = 24;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        RenameClassMemberProcessor processor = new RenameClassMemberProcessor(this.file1, selectedNode);
        processor.setNewElementName("foo1");
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        try {
            String content = FileUtils.getContents(this.file);
            Assert.assertEquals((Object)"<?php $a = new A(); $a->foo1();", (Object)content);
            content = FileUtils.getContents(this.file1);
            Assert.assertEquals((Object)"<?php class A {function foo1(){}}", (Object)content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }
}

