/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.refactoring.core.move.PHPMoveProcessor;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PHPMoveProcessorRunConfigTestCase {
    private IProject project1;
    private String configFileCont = "<?xml version='1.0' encoding='UTF-8' standalone='no'?> <launchConfiguration type='org.eclipse.php.debug.core.launching.PHPExeLaunchConfigurationType'><stringAttribute key='ATTR_FILE' value='/TestProject1/src/RunConfigTest.php'/><stringAttribute key='ATTR_FILE_FULL_PATH' value='C:\\src\\RunConfigTest.php'/><stringAttribute key='ATTR_LOCATION' value='C:\\php-cgi.exe'/> <stringAttribute key='debugOutputEncoding' value='UTF-8'/><stringAttribute key='debugTransferEncoding' value='UTF-8'/><booleanAttribute key='firstLineBreakpoint' value='true'/><stringAttribute key='org.eclipse.php.debug.core.PHP_Project' value='/TestProject1'/><booleanAttribute key='org.eclipse.php.debug.core.RunWithDebugInfo' value='true'/><stringAttribute key='org.eclipse.php.debug.coreconfiguration_delegate_class' value='org.eclipse.php.internal.debug.core.launching.PHPExecutableLaunchDelegate'/><stringAttribute key='org.eclipse.php.debug.corephp_debugger_id' value='org.eclipse.php.debug.core.zendDebugger'/><stringAttribute key='php_debug_type' value='php_exe_script_debug'/></launchConfiguration>";
    private ILaunchConfiguration config;
    private IFile configFile;

    @Before
    public void setUp() throws Exception {
        System.setProperty("disableStartupRunner", "true");
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("TestProject1");
        IFolder folder = this.project1.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile file = folder.getFile("RunConfigTest.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php class TestRenameClass{}?>".getBytes());
        if (!file.exists()) {
            file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        source = new ByteArrayInputStream(this.configFileCont.getBytes());
        this.configFile = this.project1.getFile("TestConfig.launch");
        if (!this.configFile.exists()) {
            this.configFile.create((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.configFile.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    @Test
    public void testMoveing() {
        PHPMoveProcessor processor = new PHPMoveProcessor((IResource)this.project1.getProject().getFile("src/RunConfigTest.php"));
        RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        processor.setDestination((IContainer)this.project1);
        processor.setUpdateReferences(true);
        try {
            Change change = processor.createChange((IProgressMonitor)new NullProgressMonitor());
            change.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            this.config = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(this.configFile);
            String path = this.config.getAttribute("ATTR_FILE", "");
            Assert.assertEquals((Object)"/TestProject1/RunConfigTest.php", (Object)path);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

