/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.refactoring.core.move.PHPMoveProcessor;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PHPMoveProcessorBreakPointTestCase {
    private IProject project1;

    @Before
    public void setUp() throws Exception {
        System.setProperty("disableStartupRunner", "true");
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("TestProject1");
        IFolder folder = this.project1.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile file = folder.getFile("RunBreakPoint.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php class TestRenameClass{}?>".getBytes());
        if (!file.exists()) {
            file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("location", file.getFullPath().toString());
        attributes.put("org.eclipse.wst.sse.ui.extensions.breakpoint.path", file.getFullPath().toString());
        PHPConditionalBreakpoint bp = new PHPConditionalBreakpoint((IResource)file, 1, -1, -1, attributes);
        breakpointManager.addBreakpoint((IBreakpoint)bp);
        folder = this.project1.getFolder("src1");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    @Test
    public void testMoveing() {
        PHPMoveProcessor processor = new PHPMoveProcessor((IResource)this.project1.getProject().getFolder("src"));
        RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        processor.setDestination((IContainer)this.project1.getFolder("src1"));
        processor.setUpdateReferences(true);
        try {
            Change change = processor.createChange((IProgressMonitor)new NullProgressMonitor());
            change.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
        IFile file = this.project1.getFile("src1/src/RunBreakPoint.php");
        try {
            IMarker[] markers = file.findMarkers("org.eclipse.php.debug.core.PHPConditionalBreakpointMarker", false, 1);
            Assert.assertNotNull((Object)markers);
            Assert.assertTrue((markers.length > 0 ? 1 : 0) != 0);
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint bp = breakpointManager.getBreakpoint(markers[0]);
            Assert.assertTrue((boolean)(bp instanceof PHPConditionalBreakpoint));
            Assert.assertEquals((long)1L, (long)((PHPConditionalBreakpoint)bp).getLineNumber());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

