/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.viewsupport;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionListenerWithASTManager {
    private static SelectionListenerWithASTManager fgDefault;
    private Map<ITextEditor, PartListenerGroup> fListenerGroups = new HashMap<ITextEditor, PartListenerGroup>();

    public static SelectionListenerWithASTManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SelectionListenerWithASTManager();
        }
        return fgDefault;
    }

    private SelectionListenerWithASTManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ITextEditor part, ISelectionListenerWithAST listener) {
        SelectionListenerWithASTManager selectionListenerWithASTManager = this;
        synchronized (selectionListenerWithASTManager) {
            PartListenerGroup partListener = this.fListenerGroups.get(part);
            if (partListener == null) {
                partListener = new PartListenerGroup(part);
                this.fListenerGroups.put(part, partListener);
            }
            partListener.install(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ITextEditor part, ISelectionListenerWithAST listener) {
        SelectionListenerWithASTManager selectionListenerWithASTManager = this;
        synchronized (selectionListenerWithASTManager) {
            PartListenerGroup partListener = this.fListenerGroups.get(part);
            if (partListener != null) {
                partListener.uninstall(listener);
                if (partListener.isEmpty()) {
                    this.fListenerGroups.remove(part);
                }
            }
        }
    }

    private static final class PartListenerGroup {
        private ITextEditor fPart;
        private ISelectionListener fPostSelectionListener;
        private ISelectionChangedListener fSelectionListener;
        private Job fCurrentJob;
        private ListenerList fAstListeners;
        private final Object fJobLock = new Object();

        public PartListenerGroup(ITextEditor editorPart) {
            this.fPart = editorPart;
            this.fCurrentJob = null;
            this.fAstListeners = new ListenerList(1);
            this.fSelectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof ITextSelection) {
                        PartListenerGroup.this.fireSelectionChanged((ITextSelection)selection);
                    }
                }
            };
            this.fPostSelectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (part == PartListenerGroup.this.fPart && selection instanceof ITextSelection) {
                        PartListenerGroup.this.firePostSelectionChanged((ITextSelection)selection);
                    }
                }
            };
        }

        public boolean isEmpty() {
            return this.fAstListeners.isEmpty();
        }

        public void install(ISelectionListenerWithAST listener) {
            if (this.isEmpty()) {
                this.fPart.getEditorSite().getPage().addPostSelectionListener(this.fPostSelectionListener);
                ISelectionProvider selectionProvider = this.fPart.getSelectionProvider();
                if (selectionProvider != null) {
                    selectionProvider.addSelectionChangedListener(this.fSelectionListener);
                }
            }
            this.fAstListeners.add((Object)listener);
        }

        public void uninstall(ISelectionListenerWithAST listener) {
            this.fAstListeners.remove((Object)listener);
            if (this.isEmpty()) {
                this.fPart.getEditorSite().getPage().removePostSelectionListener(this.fPostSelectionListener);
                ISelectionProvider selectionProvider = this.fPart.getSelectionProvider();
                if (selectionProvider != null) {
                    selectionProvider.removeSelectionChangedListener(this.fSelectionListener);
                }
            }
        }

        public void fireSelectionChanged(ITextSelection selection) {
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
        }

        public void firePostSelectionChanged(final ITextSelection selection) {
            ISourceModule typeRoot;
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
            if ((typeRoot = EditorUtility.getEditorInputModelElement((IEditorPart)this.fPart, (boolean)false)) == null) {
                return;
            }
            this.fCurrentJob = new Job("Selection Job titile"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus run(IProgressMonitor monitor) {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    Object object = PartListenerGroup.this.fJobLock;
                    synchronized (object) {
                        return PartListenerGroup.this.calculateASTandInform(typeRoot, selection, monitor);
                    }
                }
            };
            this.fCurrentJob.setPriority(50);
            this.fCurrentJob.setSystem(true);
            this.fCurrentJob.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final IStatus calculateASTandInform(ISourceModule input, ITextSelection selection, IProgressMonitor monitor) {
            block10: {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    Object[] listeners;
                    Program astRoot = SharedASTProvider.getAST(input, SharedASTProvider.WAIT_ACTIVE_ONLY, monitor);
                    if (astRoot == null || monitor.isCanceled()) break block10;
                    PartListenerGroup partListenerGroup = this;
                    synchronized (partListenerGroup) {
                        listeners = this.fAstListeners.getListeners();
                    }
                    int i = 0;
                    while (i < listeners.length) {
                        ((ISelectionListenerWithAST)listeners[i]).selectionChanged((IEditorPart)this.fPart, selection, astRoot);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (ModelException modelException) {
                    new Status(4, "org.eclipse.php.ui", "error retrieving AST from Provider");
                }
                catch (IOException iOException) {
                    new Status(4, "org.eclipse.php.ui", "error retrieving AST from Provider");
                }
            }
            return Status.CANCEL_STATUS;
        }
    }
}

