/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.configuration.PHPStructuredTextViewerConfiguration;
import org.eclipse.php.internal.ui.preferences.EditTemplateDialog;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.PreferencesMessages;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.text.template.TemplateVariableProcessor;
import org.eclipse.php.internal.ui.util.Messages;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.ITreeListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.SelectionButtonDialogField;
import org.eclipse.php.internal.ui.wizards.fields.TreeListDialogField;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class PHPCodeTemplateBlock
extends PHPCoreOptionsConfigurationBlock {
    private static final Key PREF_GENERATE_COMMENTS = PHPCodeTemplateBlock.getPHPCoreKey("org.eclipse.php.core.phpDoc");
    private static final int IDX_EDIT = 0;
    private static final int IDX_IMPORT = 2;
    private static final int IDX_EXPORT = 3;
    private static final int IDX_EXPORTALL = 4;
    protected static final Object COMMENT_NODE = PHPUIMessages.CodeTemplateBlock_templates_comment_node;
    protected static final Object CODE_NODE = PHPUIMessages.CodeTemplateBlock_templates_code_node;
    private TreeListDialogField fCodeTemplateTree;
    private SelectionButtonDialogField fGenerateComments;
    protected ProjectTemplateStore fTemplateStore;
    private PixelConverter fPixelConverter;
    private SourceViewer fPatternViewer;
    private TemplateVariableProcessor fTemplateProcessor;

    private static Key[] getAllKeys() {
        return new Key[]{PREF_GENERATE_COMMENTS};
    }

    public PHPCodeTemplateBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, PHPCodeTemplateBlock.getAllKeys(), container);
        this.fTemplateStore = new ProjectTemplateStore(project);
        try {
            this.fTemplateStore.load();
        }
        catch (IOException e) {
            PHPUiPlugin.log(e);
        }
        this.fTemplateProcessor = new TemplateVariableProcessor();
        CodeTemplateAdapter adapter = new CodeTemplateAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = PreferencesMessages.CodeTemplateBlock_templates_edit_button;
        stringArray[2] = PreferencesMessages.CodeTemplateBlock_templates_import_button;
        stringArray[3] = PreferencesMessages.CodeTemplateBlock_templates_export_button;
        stringArray[4] = PreferencesMessages.CodeTemplateBlock_templates_exportall_button;
        String[] buttonLabels = stringArray;
        this.fCodeTemplateTree = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CodeTemplateLabelProvider());
        this.fCodeTemplateTree.setDialogFieldListener(adapter);
        this.fCodeTemplateTree.setLabelText(PreferencesMessages.CodeTemplateBlock_templates_label);
        this.fCodeTemplateTree.setViewerComparator(adapter);
        this.fCodeTemplateTree.enableButton(3, false);
        this.fCodeTemplateTree.enableButton(0, false);
        this.fCodeTemplateTree.addElement(COMMENT_NODE);
        this.fCodeTemplateTree.addElement(CODE_NODE);
        this.fCodeTemplateTree.selectFirstElement();
        this.fGenerateComments = new SelectionButtonDialogField(96);
        this.fGenerateComments.setDialogFieldListener(adapter);
        this.fGenerateComments.setLabelText(PreferencesMessages.CodeTemplateBlock_createcomment_label);
        this.updateControls();
    }

    public void postSetSelection(Object element) {
        this.fCodeTemplateTree.postSetSelection((ISelection)new StructuredSelection(element));
    }

    @Override
    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fCodeTemplateTree.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fCodeTemplateTree.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fCodeTemplateTree.getTreeControl(null));
        this.fPatternViewer = this.createViewer(composite, 2);
        this.fGenerateComments.doFillIntoGrid(composite, 2);
        return composite;
    }

    @Override
    protected void updateControls() {
        this.fGenerateComments.setSelection(this.getBooleanValue(PREF_GENERATE_COMMENTS));
    }

    private SourceViewer createViewer(Composite parent, int nColumns) {
        Label label = new Label(parent, 0);
        label.setText(PreferencesMessages.CodeTemplateBlock_preview);
        GridData data = new GridData();
        data.horizontalSpan = nColumns;
        label.setLayoutData((Object)data);
        StructuredTextViewer viewer = new StructuredTextViewer(parent, null, null, false, 2824);
        IStructuredDocument document = StructuredModelManager.getModelManager().createStructuredDocumentFor(ContentTypeIdForPHP.ContentTypeID_PHP);
        StyledText text = viewer.getTextWidget();
        text.setLayoutData((Object)data);
        text.setEditable(false);
        text.setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        StructuredTextViewerConfiguration configuration = new StructuredTextViewerConfiguration(){
            StructuredTextViewerConfiguration baseConfiguration = new PHPStructuredTextViewerConfiguration();

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return this.baseConfiguration.getConfiguredContentTypes(sourceViewer);
            }

            public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
                return this.baseConfiguration.getLineStyleProviders(sourceViewer, partitionType);
            }
        };
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Control control = viewer.getControl();
        data = new GridData(1296);
        data.horizontalSpan = nColumns;
        data.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected TemplatePersistenceData[] getTemplateOfCategory(boolean isComment) {
        ArrayList<TemplatePersistenceData> res = new ArrayList<TemplatePersistenceData>();
        TemplatePersistenceData[] templates = this.fTemplateStore.getTemplateData();
        int i = 0;
        while (i < templates.length) {
            TemplatePersistenceData curr = templates[i];
            if (isComment == curr.getTemplate().getName().endsWith("comment")) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new TemplatePersistenceData[res.size()]);
    }

    protected static boolean canEdit(List selected) {
        return selected.size() == 1 && selected.get(0) instanceof TemplatePersistenceData;
    }

    protected void updateSourceViewerInput(List selection) {
        if (this.fPatternViewer == null || this.fPatternViewer.getTextWidget().isDisposed()) {
            return;
        }
        if (selection.size() == 1 && selection.get(0) instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.get(0);
            Template template = data.getTemplate();
            TemplateContextType type = PHPUiPlugin.getDefault().getCodeTemplateContextRegistry().getContextType(template.getContextTypeId());
            this.fTemplateProcessor.setContextType(type);
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void doButtonPressed(int buttonIndex, List selected) {
        if (buttonIndex == 0) {
            this.edit((TemplatePersistenceData)selected.get(0));
        } else if (buttonIndex == 3) {
            this.export(selected);
        } else if (buttonIndex == 4) {
            this.exportAll();
        } else if (buttonIndex == 2) {
            this.import_();
        }
    }

    private void edit(TemplatePersistenceData data) {
        Template newTemplate = new Template(data.getTemplate());
        EditTemplateDialog dialog = new EditTemplateDialog(this.getShell(), newTemplate, true, false, PHPUiPlugin.getDefault().getCodeTemplateContextRegistry());
        if (dialog.open() == 0) {
            data.setTemplate(dialog.getTemplate());
            this.fCodeTemplateTree.refresh(data);
            this.fCodeTemplateTree.selectElements((ISelection)new StructuredSelection((Object)data));
        }
    }

    private void import_() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(PreferencesMessages.CodeTemplateBlock_import_title);
        dialog.setFilterExtensions(new String[]{PreferencesMessages.CodeTemplateBlock_import_extension});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            TemplateReaderWriter reader = new TemplateReaderWriter();
            File file = new File(path);
            if (file.exists()) {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                try {
                    TemplatePersistenceData[] datas = reader.read((InputStream)input, null);
                    int i = 0;
                    while (i < datas.length) {
                        this.updateTemplate(datas[i]);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
            this.fCodeTemplateTree.refresh();
            this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
        }
        catch (FileNotFoundException e) {
            this.openReadErrorDialog(e);
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void updateTemplate(TemplatePersistenceData data) {
        TemplatePersistenceData[] datas = this.fTemplateStore.getTemplateData();
        int i = 0;
        while (i < datas.length) {
            String id = datas[i].getId();
            if (id != null && id.equals(data.getId())) {
                datas[i].setTemplate(data.getTemplate());
                break;
            }
            ++i;
        }
    }

    private void exportAll() {
        this.export(this.fTemplateStore.getTemplateData());
    }

    private void export(List selected) {
        HashSet datas = new HashSet();
        int i = 0;
        while (i < selected.size()) {
            Object curr = selected.get(i);
            if (curr instanceof TemplatePersistenceData) {
                datas.add(curr);
            } else {
                TemplatePersistenceData[] cat = this.getTemplateOfCategory(curr == COMMENT_NODE);
                datas.addAll(Arrays.asList(cat));
            }
            ++i;
        }
        this.export(datas.toArray(new TemplatePersistenceData[datas.size()]));
    }

    private void export(TemplatePersistenceData[] templates) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.format(PreferencesMessages.CodeTemplateBlock_export_title, String.valueOf(templates.length)));
        dialog.setFilterExtensions(new String[]{PreferencesMessages.CodeTemplateBlock_export_extension});
        dialog.setFileName(PreferencesMessages.CodeTemplateBlock_export_filename);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (!file.exists() || this.confirmOverwrite(file)) {
            OutputStream output = null;
            try {
                output = new BufferedOutputStream(new FileOutputStream(file));
                TemplateReaderWriter writer = new TemplateReaderWriter();
                writer.save(templates, output);
                output.close();
            }
            catch (IOException iOException) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException2) {}
                }
                this.openWriteErrorDialog();
            }
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)PreferencesMessages.CodeTemplateBlock_export_exists_title, (String)PreferencesMessages.PHPCodeTemplateBlock_2);
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        this.fTemplateStore.restoreDefaults();
        this.fCodeTemplateTree.refresh();
        this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
    }

    public boolean performOk(boolean enabled) {
        boolean res = super.performOk();
        if (!res) {
            return false;
        }
        if (this.fProject != null) {
            TemplatePersistenceData[] templateData = this.fTemplateStore.getTemplateData();
            int i = 0;
            while (i < templateData.length) {
                this.fTemplateStore.setProjectSpecific(templateData[i].getId(), enabled);
                ++i;
            }
        }
        try {
            this.fTemplateStore.save();
        }
        catch (IOException e) {
            PHPUiPlugin.log(e);
            this.openWriteErrorDialog();
        }
        return true;
    }

    public void performCancel() {
        try {
            this.fTemplateStore.revertChanges();
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void openReadErrorDialog(Exception e) {
        String title = PreferencesMessages.CodeTemplateBlock_error_read_title;
        String message = e.getLocalizedMessage();
        message = message != null ? Messages.format(PreferencesMessages.CodeTemplateBlock_error_parse_message, message) : PreferencesMessages.CodeTemplateBlock_error_read_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void openWriteErrorDialog() {
        String title = PreferencesMessages.CodeTemplateBlock_error_write_title;
        String message = PreferencesMessages.CodeTemplateBlock_error_write_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    @Override
    protected void validateSettings(Key changedKey, String oldValue, String newValue) {
    }

    private class CodeTemplateAdapter
    extends ViewerComparator
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] NO_CHILDREN = new Object[0];

        private CodeTemplateAdapter() {
        }

        @Override
        public void customButtonPressed(TreeListDialogField field, int index) {
            PHPCodeTemplateBlock.this.doButtonPressed(index, field.getSelectedElements());
        }

        @Override
        public void selectionChanged(TreeListDialogField field) {
            List selected = field.getSelectedElements();
            field.enableButton(0, PHPCodeTemplateBlock.canEdit(selected));
            field.enableButton(3, !selected.isEmpty());
            PHPCodeTemplateBlock.this.updateSourceViewerInput(selected);
        }

        @Override
        public void doubleClicked(TreeListDialogField field) {
            List selected = field.getSelectedElements();
            if (PHPCodeTemplateBlock.canEdit(selected)) {
                PHPCodeTemplateBlock.this.doButtonPressed(0, selected);
            }
        }

        @Override
        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element == COMMENT_NODE || element == CODE_NODE) {
                return PHPCodeTemplateBlock.this.getTemplateOfCategory(element == COMMENT_NODE);
            }
            return this.NO_CHILDREN;
        }

        @Override
        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof TemplatePersistenceData) {
                TemplatePersistenceData data = (TemplatePersistenceData)element;
                if (data.getTemplate().getName().endsWith("comment")) {
                    return COMMENT_NODE;
                }
                return CODE_NODE;
            }
            return null;
        }

        @Override
        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element == COMMENT_NODE || element == CODE_NODE;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            if (field == PHPCodeTemplateBlock.this.fGenerateComments) {
                PHPCodeTemplateBlock.this.setValue(PREF_GENERATE_COMMENTS, PHPCodeTemplateBlock.this.fGenerateComments.isSelected());
            }
        }

        @Override
        public void keyPressed(TreeListDialogField field, KeyEvent event) {
        }

        public int category(Object element) {
            if (element == COMMENT_NODE) {
                return 1;
            }
            if (element == CODE_NODE) {
                return 2;
            }
            TemplatePersistenceData data = (TemplatePersistenceData)element;
            String id = data.getId();
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.newtype".equals(id)) {
                return 101;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.classbody".equals(id)) {
                return 102;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.interfacebody".equals(id)) {
                return 103;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.enumbody".equals(id)) {
                return 104;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.annotationbody".equals(id)) {
                return 105;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.methodbody".equals(id)) {
                return 106;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.constructorbody".equals(id)) {
                return 107;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.getterbody".equals(id)) {
                return 108;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.setterbody".equals(id)) {
                return 109;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.catchblock".equals(id)) {
                return 110;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.filecomment".equals(id)) {
                return 1;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.typecomment".equals(id)) {
                return 2;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.fieldcomment".equals(id)) {
                return 3;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.multifieldcomment".equals(id)) {
                return 4;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.constructorcomment".equals(id)) {
                return 5;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.methodcomment".equals(id)) {
                return 6;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.overridecomment".equals(id)) {
                return 7;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.delegatecomment".equals(id)) {
                return 8;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.gettercomment".equals(id)) {
                return 9;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.settercomment".equals(id)) {
                return 10;
            }
            return 1000;
        }
    }

    private static class CodeTemplateLabelProvider
    extends LabelProvider {
        private CodeTemplateLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element == COMMENT_NODE || element == CODE_NODE) {
                return (String)element;
            }
            TemplatePersistenceData data = (TemplatePersistenceData)element;
            String id = data.getId();
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.catchblock".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_catchblock_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.methodbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_methodstub_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.constructorbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_constructorstub_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.getterbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_getterstub_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.setterbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_setterstub_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.newtype".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_newtype_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.classbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_classbody_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.interfacebody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_interfacebody_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.enumbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_enumbody_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.annotationbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_annotationbody_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.filecomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_filecomment_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.typecomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_typecomment_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.fieldcomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_fieldcomment_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.multifieldcomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_multifieldcomment_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.methodcomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_methodcomment_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.overridecomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_overridecomment_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.delegatecomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_delegatecomment_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.constructorcomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_constructorcomment_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.gettercomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_gettercomment_label;
            }
            if ("org.eclipse.php.ui.editor.templates.php.codetemplates.settercomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_settercomment_label;
            }
            return data.getTemplate().getDescription();
        }
    }
}

