/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.compare;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.php.internal.ui.compare.MergeSourceViewer;
import org.eclipse.php.internal.ui.compare.TextEditorPropertyAction;

public class ShowWhitespaceAction
extends TextEditorPropertyAction {
    private Map fPainters;
    private boolean isWhitespaceShowing;

    public ShowWhitespaceAction(MergeSourceViewer[] viewers) {
        super(CompareMessages.ShowWhitespaceAction_0, viewers, "showWhitespaceCharacters");
    }

    @Override
    protected void toggleState(boolean checked) {
        if (checked) {
            this.showWhitespace();
        } else {
            this.hideWhitespace();
        }
    }

    private synchronized Map getPainters() {
        if (this.fPainters == null) {
            this.fPainters = new HashMap();
        }
        return this.fPainters;
    }

    private void showWhitespace() {
        if (this.isWhitespaceShowing) {
            return;
        }
        try {
            Map painters = this.getPainters();
            MergeSourceViewer[] viewers = this.getViewers();
            int i = 0;
            while (i < viewers.length) {
                MergeSourceViewer viewer = viewers[i];
                WhitespaceCharacterPainter painter = new WhitespaceCharacterPainter((ITextViewer)viewer);
                viewer.addPainter((IPainter)painter);
                painters.put(viewer, painter);
                ++i;
            }
        }
        finally {
            this.isWhitespaceShowing = true;
        }
    }

    private void hideWhitespace() {
        Map painters = this.getPainters();
        for (Map.Entry entry : painters.entrySet()) {
            MergeSourceViewer viewer = (MergeSourceViewer)((Object)entry.getKey());
            WhitespaceCharacterPainter painter = (WhitespaceCharacterPainter)entry.getValue();
            if (painter == null) continue;
            viewer.removePainter((IPainter)painter);
            painter.deactivate(true);
        }
        painters.clear();
        this.isWhitespaceShowing = false;
    }
}

