/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.util.Resources;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class RefreshAction
extends SelectionDispatchAction {
    public RefreshAction(IWorkbenchSite site) {
        super(site);
        this.setText(PHPUIMessages.RefreshAction_label);
        this.setToolTipText(PHPUIMessages.RefreshAction_toolTip);
        PHPPluginImages.setLocalImageDescriptors((IAction)this, "refresh_nav.png");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.refresh_action_context");
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return true;
        }
        for (Object element : selection) {
            if (element instanceof IAdaptable) {
                IResource resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                if (resource == null) {
                    return false;
                }
                if (resource.getType() != 4 || ((IProject)resource).isOpen()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public void run(IStructuredSelection selection) {
        final IResource[] resources = this.getResources(selection);
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(PHPUIMessages.RefreshAction_progressMessage, resources.length * 2);
                monitor.subTask("");
                int r = 0;
                while (r < resources.length) {
                    IResource resource = resources[r];
                    if (resource.getType() == 4) {
                        RefreshAction.this.checkLocationDeleted((IProject)resource);
                    } else if (resource.getType() == 8) {
                        IProject[] projects = ((IWorkspaceRoot)resource).getProjects();
                        int p = 0;
                        while (p < projects.length) {
                            RefreshAction.this.checkLocationDeleted(projects[p]);
                            ++p;
                        }
                    }
                    resource.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ++r;
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), PHPUIMessages.RefreshAction_error_title, PHPUIMessages.RefreshAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IResource[] getResources(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        ArrayList<IResource> result = new ArrayList<IResource>(selection.size());
        for (Object element : selection) {
            IResource resource;
            if (!(element instanceof IAdaptable) || (resource = (IResource)((IAdaptable)element).getAdapter(IResource.class)) == null) continue;
            result.add(resource);
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (!this.isDescendent(result, resource)) continue;
            iter.remove();
        }
        return result.toArray(new IResource[result.size()]);
    }

    private boolean isDescendent(List candidates, IResource element) {
        IContainer parent = element.getParent();
        while (parent != null) {
            if (candidates.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private void checkLocationDeleted(IProject project) throws CoreException {
        if (!project.exists()) {
            return;
        }
        URI location = project.getLocationURI();
        if (location == null) {
            return;
        }
        IFileStore store = EFS.getStore((URI)location);
        if (!store.fetchInfo().exists()) {
            final String message = MessageFormat.format((String)PHPUIMessages.RefreshAction_locationDeleted_message, (Object[])new Object[]{project.getName(), Resources.getLocationString((IResource)project)});
            final boolean[] result = new boolean[1];
            this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = MessageDialog.openQuestion((Shell)RefreshAction.this.getShell(), (String)PHPUIMessages.RefreshAction_locationDeleted_title, (String)message);
                }
            });
            if (result[0]) {
                project.delete(true, true, null);
            }
        }
    }
}

