/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.sourcelookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.internal.ui.views.launch.SourceNotFoundEditorInput;
import org.eclipse.php.internal.debug.core.sourcelookup.PHPSourceLookupParticipant;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;

public class PHPSourceLookupDirector
extends AbstractSourceLookupDirector {
    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new PHPSourceLookupParticipant()});
    }

    public Object getSourceElement(Object element) {
        Object obj = super.getSourceElement(element);
        if (obj == null && element instanceof IStackFrame) {
            obj = new SourceNotFoundEditorInput((IStackFrame)element);
        }
        if (obj instanceof LocalFile && element instanceof IStackFrame) {
            IStackFrame stackFrame = (IStackFrame)element;
            LocalFile localFile = (LocalFile)obj;
            IProject project = null;
            try {
                IWorkspaceRoot workspaceRoot;
                IResource resource;
                String file;
                if (stackFrame.getLaunch() != null && stackFrame.getLaunch().getLaunchConfiguration() != null && (file = stackFrame.getLaunch().getLaunchConfiguration().getAttribute("ATTR_FILE", null)) != null && (resource = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).findMember(file)) != null) {
                    project = resource.getProject();
                }
            }
            catch (CoreException coreException) {}
            if (project != null) {
                IDebugTarget debugTarget = stackFrame.getDebugTarget();
                try {
                    HashMap links;
                    ProjectDescription desc = ((Project)project).internalGetDescription();
                    if (desc != null && (links = desc.getLinks()) != null) {
                        for (Map.Entry entry : links.entrySet()) {
                            Path filePath;
                            IPath relativePath = (IPath)entry.getKey();
                            LinkDescription linkDescription = (LinkDescription)entry.getValue();
                            Path linkPath = new Path(linkDescription.getLocationURI().getPath());
                            if (!linkPath.isPrefixOf((IPath)(filePath = new Path(localFile.toLocalFile(0, null).getAbsolutePath())))) continue;
                            filePath = filePath.removeFirstSegments(linkPath.segmentCount()).setDevice(null);
                            relativePath = relativePath.append((IPath)filePath);
                            IFile file = null;
                            file = debugTarget instanceof PHPDebugTarget ? ((PHPDebugTarget)debugTarget).getProject().getFile(relativePath) : project.getFile(relativePath);
                            if (!file.isAccessible()) continue;
                            return file;
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return obj;
    }
}

