/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.compiler_ast.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractPHPSourceParser;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPSourceParserFactory;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class CompilerParserTests {
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    private AbstractPHPSourceParser parser;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/compiler_parser/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/compiler_parser/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55", "/workspace/compiler_parser/php56"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55", "/workspace/compiler_parser/php56", "/workspace/compiler_parser/php7"});
    }

    public CompilerParserTests(PHPVersion version, String[] fileNames) {
        this.parser = PHPSourceParserFactory.createParser((PHPVersion)version);
    }

    @Test
    public void parserTest(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(PHPCoreTests.getDefault().getBundle(), fileName, "UTF-8");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdttFile.getFile().trim().getBytes("UTF-8"));
        IModuleDeclaration moduleDeclaration = this.parser.parse((Reader)new InputStreamReader((InputStream)inputStream, "UTF-8"), null, ProjectOptions.useShortTags(null));
        String actual = ASTPrintVisitor.toXMLString((ASTNode)((ASTNode)moduleDeclaration));
        PDTTUtils.assertContents(pdttFile.getExpected(), actual);
    }
}

