/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.Logger;
import org.osgi.framework.Bundle;

public class TestBuildpathInitializer
extends BuildpathContainerInitializer {
    private static final String LIBRARY = ".LIBRARY.";

    public void initialize(IPath containerPath, IScriptProject project) throws CoreException {
        String segment;
        int i;
        if (containerPath.segmentCount() > 0 && (i = (segment = containerPath.segment(0)).indexOf(LIBRARY)) != -1) {
            String library = segment.substring(i + LIBRARY.length());
            BuildpathContainer container = new BuildpathContainer(String.valueOf(library) + " Library", containerPath, "libraries/" + library, project);
            DLTKCore.setBuildpathContainer((IPath)containerPath, (IScriptProject[])new IScriptProject[]{project}, (IBuildpathContainer[])new IBuildpathContainer[]{container}, null);
        }
    }

    class BuildpathContainer
    implements IBuildpathContainer {
        private String description;
        private IPath containerPath;
        private String libraryPath;
        private IBuildpathEntry[] buildPathEntries;
        private IScriptProject fProject;

        public BuildpathContainer(String description, IPath containerPath, String libraryPath, IScriptProject project) {
            this.description = description;
            this.containerPath = containerPath;
            this.libraryPath = libraryPath;
            this.fProject = project;
        }

        public IBuildpathEntry[] getBuildpathEntries(IScriptProject project) {
            if (this.buildPathEntries == null) {
                IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)project);
                try {
                    URL url = FileLocator.find((Bundle)PHPCoreTests.getDefault().getBundle(), (IPath)new Path(this.libraryPath), null);
                    URL resolved = FileLocator.resolve((URL)url);
                    IPath path = Path.fromOSString((String)resolved.getFile());
                    if (environment != null) {
                        path = EnvironmentPathUtils.getFullPath((IEnvironment)environment, (IPath)path);
                    }
                    this.buildPathEntries = new IBuildpathEntry[]{DLTKCore.newLibraryEntry((IPath)path, (IAccessRule[])BuildpathEntry.NO_ACCESS_RULES, (IBuildpathAttribute[])BuildpathEntry.NO_EXTRA_ATTRIBUTES, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])BuildpathEntry.EXCLUDE_NONE, (boolean)false, (boolean)true)};
                }
                catch (Exception e) {
                    Logger.logException((Throwable)e);
                }
            }
            return this.buildPathEntries != null ? this.buildPathEntries : new IBuildpathEntry[]{};
        }

        public String getDescription() {
            return this.description;
        }

        public int getKind() {
            return 2;
        }

        public IPath getPath() {
            return this.containerPath;
        }

        public IBuildpathEntry[] getBuildpathEntries() {
            return this.getBuildpathEntries(this.fProject);
        }
    }
}

