/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.views.PHPStackLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class PHPStackView
extends AbstractDebugView
implements ISelectionListener {
    private PHPDebugTarget fTarget;
    private boolean isVisible;

    protected Viewer createViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent);
        viewer.setLabelProvider((IBaseLabelProvider)new PHPStackLabelProvider());
        viewer.setContentProvider((IContentProvider)new StackViewContentProvider());
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        return viewer;
    }

    protected String getHelpContextId() {
        return null;
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.fTarget = null;
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.update();
    }

    protected void becomesHidden() {
        this.isVisible = false;
        super.becomesHidden();
    }

    protected void becomesVisible() {
        this.isVisible = true;
        this.update();
        super.becomesVisible();
    }

    private synchronized void update() {
        if (!this.isVisible) {
            return;
        }
        IAdaptable adaptable = DebugUITools.getDebugContext();
        this.fTarget = null;
        IDebugElement element = null;
        if (adaptable != null && (element = (IDebugElement)adaptable.getAdapter(IDebugElement.class)) != null && element.getModelIdentifier().equals("org.eclipse.php.debug.core")) {
            this.fTarget = (PHPDebugTarget)element.getDebugTarget();
        }
        IDebugElement input = null;
        if (this.fTarget != null && this.fTarget.isSuspended()) {
            input = element;
        }
        this.getViewer().setInput(input);
        this.getViewer().refresh();
    }

    protected void createActions() {
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void updateObjects() {
        super.updateObjects();
        this.update();
    }

    class StackViewContentProvider
    implements ITreeContentProvider {
        StackViewContentProvider() {
        }

        public Object[] getChildren(Object element) {
            try {
                if (element instanceof PHPDebugTarget) {
                    IThread[] threads = ((PHPDebugTarget)element).getThreads();
                    if (threads != null && threads[0] != null) {
                        return ((PHPThread)threads[0]).getStackVariables();
                    }
                } else {
                    if (element instanceof PHPThread) {
                        return ((PHPThread)element).getStackVariables();
                    }
                    if (element instanceof PHPStackFrame) {
                        return ((PHPStackFrame)element).getStackVariables();
                    }
                    if (element instanceof Expression) {
                        Expression eExp = (Expression)element;
                        ExpressionValue value = eExp.getValue();
                        Object[] eChildren = value.getChildren();
                        if (eChildren == null) {
                            return new Expression[0];
                        }
                        if (eChildren.length == 0) {
                            DefaultExpressionsManager expressionManager = PHPStackView.this.fTarget.getExpressionManager();
                            expressionManager.update(eExp, 1);
                            value = eExp.getValue();
                            eChildren = value.getChildren();
                            if (eChildren == null) {
                                eChildren = new Expression[]{};
                            }
                        }
                        return eChildren;
                    }
                }
            }
            catch (DebugException e) {
                Logger.logException("StackViewContentProvider unexpected error", e);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IDebugTarget) {
                return null;
            }
            if (element instanceof IDebugElement) {
                return ((IDebugElement)element).getDebugTarget();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IDebugElement) {
                return this.getChildren(element).length > 0;
            }
            if (element instanceof Expression) {
                Expression eExp = (Expression)element;
                ExpressionValue value = eExp.getValue();
                Expression[] eChildren = value.getChildren();
                return eChildren != null;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

