/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.breakpoint;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension4;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.extension.BreakpointProviderBuilder;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IBreakpointProvider;
import org.osgi.framework.Bundle;

public class ScriptLineBreakpointAdapter
implements IToggleBreakpointsTarget {
    protected IVerticalRulerInfo fRulerInfo = null;

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        PHPStructuredEditor textEditor = this.getEditor(part);
        return textEditor != null;
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor editor = (ITextEditor)part.getAdapter(ITextEditor.class);
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            int lineNumber = -1;
            try {
                lineNumber = document.getLineOfOffset(textSelection.getOffset());
            }
            catch (BadLocationException badLocationException) {}
            if (lineNumber >= 0) {
                AbstractMarkerAnnotationModel model;
                IResource resource = this.getResource(editor.getEditorInput());
                IBreakpoint[] breakpoints = this.getBreakpoints(resource, document, model = this.getAnnotationModel(editor), lineNumber);
                if (breakpoints.length > 0) {
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    int i = 0;
                    while (i < breakpoints.length) {
                        breakpoints[i].getMarker().delete();
                        breakpointManager.removeBreakpoint(breakpoints[i], true);
                        ++i;
                    }
                } else {
                    this.createBreakpoints(editor, lineNumber + 1);
                }
            }
        }
    }

    protected String getContentType(ITextEditor editor, IDocument document) {
        IModelManager mgr = StructuredModelManager.getModelManager();
        String contentType = null;
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension4) {
            try {
                IContentType type = ((IDocumentProviderExtension4)provider).getContentType((Object)editor.getEditorInput());
                if (type != null) {
                    contentType = type.getId();
                }
            }
            catch (CoreException coreException) {}
        }
        if (contentType == null) {
            IStructuredModel model = null;
            try {
                model = mgr.getExistingModelForRead(document);
                if (model != null) {
                    contentType = model.getContentTypeIdentifier();
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return contentType;
    }

    public static final String getFileExtension(IEditorInput input) {
        IPath path = null;
        if (input instanceof IStorageEditorInput) {
            try {
                path = ((IStorageEditorInput)input).getStorage().getFullPath();
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        if (path != null) {
            return path.getFileExtension();
        }
        String name = input.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        if (index == name.length() - 1) {
            return "";
        }
        return name.substring(index + 1);
    }

    protected boolean createBreakpoints(ITextEditor editor, int lineNumber) {
        IEditorInput input = editor.getEditorInput();
        IDocument document = editor.getDocumentProvider().getDocument((Object)input);
        if (document == null) {
            return false;
        }
        String contentType = this.getContentType(editor, document);
        IBreakpointProvider[] providers = BreakpointProviderBuilder.getInstance().getBreakpointProviders((IEditorPart)editor, contentType, ScriptLineBreakpointAdapter.getFileExtension(input));
        int pos = -1;
        ISourceEditingTextTools tools = (ISourceEditingTextTools)editor.getAdapter(ISourceEditingTextTools.class);
        if (tools != null) {
            pos = tools.getCaretOffset();
        }
        int n = providers.length;
        ArrayList<IStatus> errors = new ArrayList<IStatus>(0);
        int i = 0;
        while (i < n) {
            try {
                IStatus status = providers[i].addBreakpoint(document, input, lineNumber, pos);
                if (status != null && !status.isOK()) {
                    errors.add(status);
                }
            }
            catch (CoreException e) {
                errors.add(e.getStatus());
            }
            catch (Exception t) {
                Logger.logException("exception while adding breakpoint", t);
            }
            ++i;
        }
        Object status = null;
        if (errors.size() > 0) {
            Shell shell = editor.getSite().getShell();
            status = errors.size() > 1 ? new MultiStatus("org.eclipse.wst.sse.ui", 0, errors.toArray(new IStatus[0]), SSEUIMessages.ManageBreakpoints_error_adding_message1, null) : (IStatus)errors.get(0);
            if (status.getSeverity() > 1 || Platform.inDebugMode() && !status.isOK()) {
                Platform.getLog((Bundle)SSEUIPlugin.getDefault().getBundle()).log(status);
            }
            if (status.getSeverity() > 1 || this.getBreakpoints(this.getMarkers(editor)).length < 1) {
                ErrorDialog.openError((Shell)shell, (String)SSEUIMessages.ManageBreakpoints_error_adding_title1, (String)status.getMessage(), (IStatus)status);
                return false;
            }
        }
        return true;
    }

    protected IBreakpoint[] getBreakpoints(IMarker[] markers) {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>(markers.length);
        int i = 0;
        while (i < markers.length) {
            IBreakpoint breakpoint = manager.getBreakpoint(markers[i]);
            if (breakpoint != null) {
                breakpoints.add(breakpoint);
            }
            ++i;
        }
        return breakpoints.toArray(new IBreakpoint[0]);
    }

    protected IDocument getDocument(ITextEditor editor) {
        IDocumentProvider provider = editor.getDocumentProvider();
        return provider.getDocument((Object)editor.getEditorInput());
    }

    protected IMarker[] getMarkers(ITextEditor editor) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IResource resource = this.getResource(editor.getEditorInput());
        IDocument document = this.getDocument(editor);
        AbstractMarkerAnnotationModel annotationModel = this.getAnnotationModel(editor);
        if (resource != null && annotationModel != null && resource.exists()) {
            try {
                IMarker[] allMarkers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 0);
                if (allMarkers != null) {
                    int i = 0;
                    while (i < allMarkers.length) {
                        if (this.includesRulerLine(editor, annotationModel.getMarkerPosition(allMarkers[i]), document)) {
                            markers.add(allMarkers[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return markers.toArray(new IMarker[0]);
    }

    protected boolean includesRulerLine(ITextEditor editor, Position position, IDocument document) {
        return false;
    }

    private IBreakpoint[] getBreakpoints(IResource resource, IDocument document, AbstractMarkerAnnotationModel model, int lineNumber) {
        ArrayList<IMarker> markers;
        block9: {
            markers = new ArrayList<IMarker>();
            if (document != null && resource != null && model != null && resource.exists()) {
                try {
                    IMarker[] allMarkers = resource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    if (allMarkers == null) break block9;
                    int i = 0;
                    while (i < allMarkers.length) {
                        Position p = model.getMarkerPosition(allMarkers[i]);
                        int markerLine = -1;
                        try {
                            markerLine = document.getLineOfOffset(p.getOffset());
                        }
                        catch (BadLocationException badLocationException) {}
                        if (markerLine == lineNumber) {
                            markers.add(allMarkers[i]);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>(markers.size());
        int i = 0;
        while (i < markers.size()) {
            IBreakpoint breakpoint = manager.getBreakpoint((IMarker)markers.get(i));
            if (breakpoint != null) {
                breakpoints.add(breakpoint);
            }
            ++i;
        }
        return breakpoints.toArray(new IBreakpoint[0]);
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel(ITextEditor editor) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)editor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    private PHPStructuredEditor getEditor(IWorkbenchPart part) {
        if (part instanceof PHPStructuredEditor) {
            return (PHPStructuredEditor)part;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IResource getResource(IEditorInput input) {
        IFile resource = null;
        if (input instanceof IFileEditorInput) {
            resource = ((IFileEditorInput)input).getFile();
        }
        if (resource == null) {
            resource = (IResource)input.getAdapter(IFile.class);
        }
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        IEditorPart editorPart = null;
        if (resource != null) return resource;
        IWorkbench workbench = SSEUIPlugin.getDefault().getWorkbench();
        if (workbench == null) return resource;
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) return resource;
        IPartService service = window.getPartService();
        if (service == null) return resource;
        IWorkbenchPart part = service.getActivePart();
        if (part == null) return resource;
        if (!(part instanceof IEditorPart)) return resource;
        editorPart = (IEditorPart)part;
        IStructuredModel model = null;
        ITextEditor textEditor = null;
        try {
            try {
                if (editorPart instanceof ITextEditor) {
                    textEditor = (ITextEditor)editorPart;
                }
                if (textEditor == null) {
                    textEditor = (ITextEditor)editorPart.getAdapter(ITextEditor.class);
                }
                if (textEditor != null) {
                    IDocument textDocument = textEditor.getDocumentProvider().getDocument((Object)input);
                    model = StructuredModelManager.getModelManager().getExistingModelForRead(textDocument);
                    if (model != null) {
                        resource = BreakpointProviderBuilder.getInstance().getResource(input, model.getContentTypeIdentifier(), ScriptLineBreakpointAdapter.getFileExtension(input));
                    }
                }
                if (resource != null) return resource;
                IBreakpointProvider[] providers = BreakpointProviderBuilder.getInstance().getBreakpointProviders(editorPart, null, ScriptLineBreakpointAdapter.getFileExtension(input));
                int i = 0;
                while (i < providers.length) {
                    if (resource != null) {
                        return resource;
                    }
                    resource = providers[i].getResource(input);
                    ++i;
                }
                return resource;
            }
            catch (Exception e) {
                Logger.logException(e);
                if (model == null) return resource;
                model.releaseFromRead();
                return resource;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }
}

