/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.preferences;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.php.internal.core.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPreferencesReader {
    public static final char DELIMITER = '\u0005';
    protected static final Pattern LT_PATTERN = Pattern.compile("&lt;");
    protected static final Pattern GT_PATTERN = Pattern.compile("&gt;");
    protected static final Pattern QUOT_PATTERN = Pattern.compile("&quot;");
    protected static final Pattern APOS_PATTERN = Pattern.compile("&apos;");
    protected static final Pattern AMP_PATTERN = Pattern.compile("&amp;");
    public static final String STRING_DEFAULT = "";

    public static String getUnEscaped(String s) {
        s = LT_PATTERN.matcher(s).replaceAll("<");
        s = GT_PATTERN.matcher(s).replaceAll(">");
        s = QUOT_PATTERN.matcher(s).replaceAll("\"");
        s = APOS_PATTERN.matcher(s).replaceAll("'");
        s = AMP_PATTERN.matcher(s).replaceAll("&");
        return s;
    }

    private static HashMap read(NodeList nl) {
        HashMap<String, Object> map = new HashMap<String, Object>(nl.getLength());
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.hasChildNodes()) {
                if (n.getFirstChild().getNodeType() == 3) {
                    map.put(n.getNodeName(), XMLPreferencesReader.getUnEscaped(n.getFirstChild().getNodeValue()));
                } else {
                    map.put(n.getNodeName(), XMLPreferencesReader.read(n.getChildNodes()));
                }
            }
            ++i;
        }
        return map;
    }

    private static Map<String, Object> read(NodeList nodeList, boolean skipEmptyNodes) {
        HashMap<String, Object> map = new HashMap<String, Object>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node n = nodeList.item(i);
            if (n.hasChildNodes()) {
                if (n.getFirstChild().getNodeType() == 3) {
                    map.put(n.getNodeName(), XMLPreferencesReader.getUnEscaped(n.getFirstChild().getNodeValue()));
                } else {
                    map.put(n.getNodeName(), XMLPreferencesReader.read(n.getChildNodes(), skipEmptyNodes));
                }
            } else if (!skipEmptyNodes) {
                map.put(n.getNodeName(), STRING_DEFAULT);
            }
            ++i;
        }
        return map;
    }

    protected static HashMap read(String str) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(str.getBytes()));
            return XMLPreferencesReader.read(doc.getChildNodes());
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    protected static Map<String, Object> read(String str, boolean skipEmptyNodes) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(str.getBytes()));
            return XMLPreferencesReader.read(doc.getChildNodes(), skipEmptyNodes);
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    public static HashMap[] read(Preferences store, String prefsKey) {
        String storedValue = store.getString(prefsKey);
        return XMLPreferencesReader.getHashFromStoredValue(storedValue);
    }

    public static List<Map<String, Object>> read(IEclipsePreferences store, String prefsKey, boolean skipEmptyNodes) {
        String storedValue = store.get(prefsKey, null);
        if (storedValue == null) {
            return new ArrayList<Map<String, Object>>();
        }
        return XMLPreferencesReader.getMapsFromValue(storedValue, skipEmptyNodes);
    }

    public static HashMap[] getHashFromStoredValue(String storedValue) {
        ArrayList<HashMap> maps = new ArrayList<HashMap>();
        StringTokenizer st = new StringTokenizer(storedValue, new String(new char[]{'\u0005'}));
        while (st.hasMoreTokens()) {
            maps.add(XMLPreferencesReader.read(st.nextToken()));
        }
        return maps.toArray(new HashMap[maps.size()]);
    }

    public static List<Map<String, Object>> getMapsFromValue(String storedValue, boolean skipEmptyNodes) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        StringTokenizer st = new StringTokenizer(storedValue, new String(new char[]{'\u0005'}));
        while (st.hasMoreTokens()) {
            maps.add(XMLPreferencesReader.read(st.nextToken(), skipEmptyNodes));
        }
        return maps;
    }
}

