/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class OutlineFilter {
    public static IModelElement[] filterChildrenForOutline(Object parent, IModelElement[] children) {
        return OutlineFilter.filterDuplicatePublicVars(parent, OutlineFilter.filter(children));
    }

    public static IModelElement[] filter(IModelElement[] children) {
        boolean initializers = false;
        int i = 0;
        while (i < children.length) {
            if (OutlineFilter.matches(children[i])) {
                initializers = true;
                break;
            }
            ++i;
        }
        if (!initializers) {
            return children;
        }
        Vector<IModelElement> v = new Vector<IModelElement>();
        int i2 = 0;
        while (i2 < children.length) {
            if (!OutlineFilter.matches(children[i2])) {
                v.addElement(children[i2]);
            }
            ++i2;
        }
        Object[] result = new IModelElement[v.size()];
        v.copyInto(result);
        return result;
    }

    public static IModelElement[] filterDuplicatePublicVars(Object parent, IModelElement[] children) {
        if (!(parent instanceof ISourceModule)) {
            return children;
        }
        TreeSet<IModelElement> result = new TreeSet<IModelElement>(new Comparator<IModelElement>(){

            @Override
            public int compare(IModelElement o1, IModelElement o2) {
                if (o1 instanceof IField && o2 instanceof IField && PHPModelUtils.isSameField((IField)o1, (IField)o2)) {
                    return 0;
                }
                return 1;
            }
        });
        int i = 0;
        while (i < children.length) {
            result.add(children[i]);
            ++i;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    public static boolean matches(IModelElement element) {
        if (element.getElementType() == 9) {
            String name = element.getElementName();
            return name != null && name.indexOf(60) >= 0;
        }
        IModelElement parent = element.getParent();
        if (parent != null) {
            int parentType = parent.getElementType();
            if (element.getElementType() == 8) {
                if (parentType != 9 && parentType != 7) {
                    return false;
                }
                if (parentType == 9) {
                    return true;
                }
            }
        } else if (element.getElementType() == 11) {
            return true;
        }
        return false;
    }
}

