/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.parser.regions;

import java.io.IOException;
import java.io.Reader;
import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.documentModel.parser.AbstractPhpLexer;
import org.eclipse.php.internal.core.documentModel.parser.PhpLexerFactory;
import org.eclipse.php.internal.core.documentModel.parser.Scanner;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpTokenContainer;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.Logger;

public class PhpScriptRegion
extends ForeignRegion
implements IPhpScriptRegion {
    private static final String PHP_SCRIPT = "PHP Script";
    private PhpTokenContainer tokensContaier = new PhpTokenContainer();
    private IProject project;
    private int updatedTokensStart = -1;
    private int updatedTokensEnd = -1;
    private int ST_PHP_LINE_COMMENT = -1;
    private int ST_PHP_IN_SCRIPTING = -1;
    protected boolean isFullReparsed;

    @Override
    public int getUpdatedTokensStart() {
        return this.updatedTokensStart;
    }

    @Override
    public int getUpdatedTokensLength() {
        return this.updatedTokensEnd - this.updatedTokensStart;
    }

    public PhpScriptRegion(String newContext, int startOffset, IProject project, AbstractPhpLexer phpLexer) {
        super(newContext, startOffset, 0, 0, PHP_SCRIPT);
        this.project = project;
        try {
            this.ST_PHP_LINE_COMMENT = phpLexer.getClass().getField("ST_PHP_LINE_COMMENT").getInt(phpLexer);
            this.ST_PHP_IN_SCRIPTING = phpLexer.getClass().getField("ST_PHP_IN_SCRIPTING").getInt(phpLexer);
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        this.completeReparse(phpLexer);
    }

    @Override
    public final String getPhpTokenType(int offset) throws BadLocationException {
        ITextRegion tokenForOffset = this.getPhpToken(offset);
        return tokenForOffset.getType();
    }

    @Override
    public final ITextRegion getPhpToken(int offset) throws BadLocationException {
        return this.tokensContaier.getToken(offset);
    }

    @Override
    public final ITextRegion[] getPhpTokens(int offset, int length) throws BadLocationException {
        return this.tokensContaier.getTokens(offset, length);
    }

    @Override
    public ITextRegion[] getUpdatedPhpTokens() throws BadLocationException {
        if (this.updatedTokensStart == -1) {
            return null;
        }
        return this.tokensContaier.getTokens(this.updatedTokensStart, this.updatedTokensEnd - this.updatedTokensStart);
    }

    @Override
    public String getPartition(int offset) throws BadLocationException {
        return this.tokensContaier.getPartitionType(offset);
    }

    @Override
    public boolean isLineComment(int offset) throws BadLocationException {
        Scanner.LexerState lexState = this.tokensContaier.getState(offset);
        return lexState != null && lexState.getTopState() == this.ST_PHP_LINE_COMMENT;
    }

    @Override
    public boolean isFullReparsed() {
        return this.isFullReparsed;
    }

    @Override
    public void setFullReparsed(boolean isFullReparse) {
        this.isFullReparsed = isFullReparse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion flatnode, String changes, int requestStart, int lengthToReplace) {
        this.isFullReparsed = true;
        this.updatedTokensStart = -1;
        try {
            int offset = requestStart - flatnode.getStartOffset() - this.getStart();
            if (offset < 4) {
                return null;
            }
            String deletedText = lengthToReplace == 0 ? "" : flatnode.getParentDocument().get(requestStart, lengthToReplace);
            int length = changes.length();
            if (this.startQuoted(deletedText)) return null;
            if (this.startQuoted(changes)) {
                return null;
            }
            PhpTokenContainer phpTokenContainer = this.tokensContaier;
            synchronized (phpTokenContainer) {
                ITextRegion tokenStart = this.tokensContaier.getToken(offset == 0 ? 0 : offset - 1);
                ITextRegion tokenEnd = this.tokensContaier.getToken(offset + lengthToReplace);
                while ("UNKNOWN_TOKEN".equals(tokenStart.getType()) && tokenStart.getStart() > 0) {
                    tokenStart = this.tokensContaier.getToken(tokenStart.getStart() - 1);
                }
                while ("UNKNOWN_TOKEN".equals(tokenEnd.getType()) && this.tokensContaier.getLastToken() != tokenEnd) {
                    tokenEnd = this.tokensContaier.getToken(tokenEnd.getEnd());
                }
                boolean shouldDeprecatedKeyword = false;
                int previousIndex = this.tokensContaier.phpTokens.indexOf(tokenStart) - 1;
                if (previousIndex >= 0) {
                    ITextRegion previousRegion = (ITextRegion)this.tokensContaier.phpTokens.get(previousIndex);
                    if (PhpTokenContainer.deprecatedKeywordAfter(previousRegion.getType())) {
                        shouldDeprecatedKeyword = true;
                    }
                    if (tokenStart.getType().equals("PHP_COMMENT") && tokenStart.getLength() == 1 && previousRegion.getType().equals("PHP_COMMENT_START")) {
                        requestStart = previousRegion.getStart();
                    }
                }
                int newTokenOffset = tokenStart.getStart();
                if (this.isHereDoc(tokenStart)) {
                    return null;
                }
                Scanner.LexerState startState = this.tokensContaier.getState(newTokenOffset);
                Scanner.LexerState endState = this.tokensContaier.getState(tokenEnd.getEnd());
                PhpTokenContainer newContainer = new PhpTokenContainer();
                AbstractPhpLexer phpLexer = this.getPhpLexer(new DocumentReader(flatnode, changes, requestStart, lengthToReplace, newTokenOffset), startState);
                Object state = startState;
                try {
                    int yylength;
                    String yylex = phpLexer.getNextToken();
                    if (shouldDeprecatedKeyword && PhpTokenContainer.isKeyword(yylex)) {
                        yylex = "PHP_LABEL";
                    }
                    int toOffset = offset + length;
                    while (yylex != null && newTokenOffset <= toOffset && yylex != "PHP_CLOSETAG") {
                        yylength = phpLexer.getLength();
                        newContainer.addLast(yylex, newTokenOffset, yylength, yylength, state);
                        newTokenOffset += yylength;
                        state = phpLexer.createLexicalStateMemento();
                        yylex = phpLexer.getNextToken();
                    }
                    if (yylex == "WHITESPACE") {
                        yylength = phpLexer.getLength();
                        newContainer.adjustWhitespace(yylex, newTokenOffset, yylength, yylength, state);
                    }
                }
                catch (IOException e) {
                    Logger.logException((Throwable)e);
                }
                if (newContainer.isEmpty()) {
                    return null;
                }
                int size = length - lengthToReplace;
                int end = newContainer.getLastToken().getEnd();
                if (!state.equals(endState)) return null;
                if (tokenEnd.getEnd() + size != end) {
                    return null;
                }
                ListIterator<ContextRegion> oldIterator = this.tokensContaier.removeTokensSubList(tokenStart, tokenEnd);
                ITextRegion[] newTokens = newContainer.getPhpTokens();
                int i = 0;
                while (i < newTokens.length) {
                    oldIterator.add((ContextRegion)newTokens[i]);
                    ++i;
                }
                while (oldIterator.hasNext()) {
                    ITextRegion adjust = (ITextRegion)oldIterator.next();
                    adjust.adjustStart(size);
                }
                this.tokensContaier.updateStateChanges(newContainer, tokenStart.getStart(), end);
                this.updatedTokensStart = tokenStart.getStart();
                this.updatedTokensEnd = end;
                this.isFullReparsed = false;
                return super.updateRegion(requester, flatnode, changes, requestStart, lengthToReplace);
            }
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public void completeReparse(IDocument doc, int start, int length) {
        AbstractPhpLexer phpLexer = this.getPhpLexer(new BlockDocumentReader(doc, start, length), null);
        try {
            this.ST_PHP_LINE_COMMENT = phpLexer.getClass().getField("ST_PHP_LINE_COMMENT").getInt(phpLexer);
            this.ST_PHP_IN_SCRIPTING = phpLexer.getClass().getField("ST_PHP_IN_SCRIPTING").getInt(phpLexer);
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        this.completeReparse(phpLexer);
    }

    public void equatePositions(ITextRegion region) {
        super.equatePositions(region);
        if (region instanceof PhpScriptRegion) {
            PhpScriptRegion sRegion = (PhpScriptRegion)region;
            this.tokensContaier = (PhpTokenContainer)sRegion.tokensContaier.clone();
            this.project = sRegion.project;
            this.updatedTokensStart = sRegion.updatedTokensStart;
            this.updatedTokensEnd = sRegion.updatedTokensEnd;
            this.ST_PHP_LINE_COMMENT = sRegion.ST_PHP_LINE_COMMENT;
            this.ST_PHP_IN_SCRIPTING = sRegion.ST_PHP_IN_SCRIPTING;
            this.isFullReparsed = sRegion.isFullReparsed;
        }
    }

    private final synchronized boolean isHereDoc(ITextRegion tokenStart) {
        block8: {
            if (tokenStart.getType() == "PHP_TOKEN") {
                try {
                    ITextRegion token = this.tokensContaier.getToken(tokenStart.getStart() - 1);
                    return token.getType() == "PHP_OPERATOR" && token.getLength() == 2;
                }
                catch (BadLocationException badLocationException) {
                    assert (false);
                    break block8;
                }
            }
            if (tokenStart.getType() == "PHP_LABEL") {
                try {
                    ITextRegion token = this.tokensContaier.getToken(tokenStart.getStart() - 1);
                    if (token != null) {
                        return (token = this.tokensContaier.getToken(token.getStart() - 1)) != null && token.getType() == "PHP_OPERATOR" && token.getLength() == 2;
                    }
                }
                catch (BadLocationException badLocationException) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
        }
        return false;
    }

    private boolean startQuoted(String text) {
        int length = text.length();
        if (length == 0) {
            return false;
        }
        boolean isOdd = false;
        int index = 0;
        while (index < length) {
            char charAt = text.charAt(index);
            if (charAt == '\"' || charAt == '\'') {
                isOdd = !isOdd;
            }
            ++index;
        }
        return isOdd;
    }

    public void completeReparse(AbstractPhpLexer lexer) {
        this.setPhpTokens(lexer);
    }

    private AbstractPhpLexer getPhpLexer(Reader stream, Scanner.LexerState startState) {
        PHPVersion phpVersion = ProjectOptions.getPhpVersion(this.project);
        AbstractPhpLexer lexer = PhpLexerFactory.createLexer(stream, phpVersion);
        lexer.initialize(this.ST_PHP_IN_SCRIPTING);
        lexer.setPatterns(this.project);
        if (startState != null) {
            startState.restoreState(lexer);
        }
        lexer.setAspTags(ProjectOptions.isSupportingAspTags(this.project));
        return lexer;
    }

    private synchronized void setPhpTokens(AbstractPhpLexer lexer) {
        this.setLength(0);
        this.setTextLength(0);
        this.isFullReparsed = true;
        assert (lexer != null);
        int start = 0;
        this.tokensContaier.getModelForCreation();
        this.tokensContaier.reset();
        try {
            try {
                Object state = lexer.createLexicalStateMemento();
                String yylex = lexer.getNextToken();
                int yylength = 0;
                while (yylex != null && yylex != "PHP_CLOSETAG") {
                    yylength = lexer.getLength();
                    this.tokensContaier.addLast(yylex, start, yylength, yylength, state);
                    start += yylength;
                    state = lexer.createLexicalStateMemento();
                    yylex = lexer.getNextToken();
                }
                this.adjustLength(start);
                this.adjustTextLength(start);
            }
            catch (IOException e) {
                Logger.logException((Throwable)e);
                this.tokensContaier.releaseModelFromCreation();
            }
        }
        finally {
            this.tokensContaier.releaseModelFromCreation();
        }
    }

    public static class BlockDocumentReader
    extends Reader {
        private static final String BAD_LOCATION_ERROR = "Bad location error ";
        private final IDocument parent;
        private int startPhpRegion;
        private final int endPhpRegion;

        public BlockDocumentReader(IDocument parent, int startPhpRegion, int length) {
            this.parent = parent;
            this.startPhpRegion = startPhpRegion;
            this.endPhpRegion = startPhpRegion + length;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.startPhpRegion < this.endPhpRegion ? (int)this.parent.getChar(this.startPhpRegion++) : -1;
            }
            catch (BadLocationException badLocationException) {
                throw new IOException(BAD_LOCATION_ERROR + this.startPhpRegion);
            }
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (char)c;
            int i = 1;
            try {
                while (i < len) {
                    c = this.read();
                    if (c != -1) {
                        b[off + i] = (char)c;
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {}
            return i;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class DocumentReader
    extends Reader {
        private static final String BAD_LOCATION_ERROR = "Bad location error ";
        private final IStructuredDocument parent;
        private final int startPhpRegion;
        private final int endPhpRegion;
        private final int changeLength;
        private final String change;
        private final int requestStart;
        private final int lengthToReplace;
        private int index;
        private int internalIndex = 0;

        public DocumentReader(IStructuredDocumentRegion flatnode, String change, int requestStart, int lengthToReplace, int newTokenOffset) {
            this.parent = flatnode.getParentDocument();
            this.startPhpRegion = flatnode.getStart() + PhpScriptRegion.this.getStart();
            this.endPhpRegion = this.startPhpRegion + PhpScriptRegion.this.getLength();
            this.changeLength = change.length();
            this.index = this.startPhpRegion + newTokenOffset;
            this.change = change;
            this.requestStart = requestStart;
            this.lengthToReplace = lengthToReplace;
        }

        @Override
        public int read() throws IOException {
            try {
                if (this.index < this.requestStart) {
                    return this.parent.getChar(this.index++);
                }
                if (this.internalIndex < this.changeLength) {
                    return this.change.charAt(this.internalIndex++);
                }
                if (this.index < this.requestStart + this.lengthToReplace) {
                    this.index = this.requestStart + this.lengthToReplace;
                }
                return this.index < this.endPhpRegion ? (int)this.parent.getChar(this.index++) : -1;
            }
            catch (BadLocationException badLocationException) {
                throw new IOException(BAD_LOCATION_ERROR);
            }
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            int n = len = len > 80 ? 80 : len;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (char)c;
            int i = 1;
            try {
                while (i < len) {
                    c = this.read();
                    if (c != -1) {
                        b[off + i] = (char)c;
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {}
            return i;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

