/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionDeclarationContext;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class FunctionReturnTypeContext
extends FunctionDeclarationContext {
    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        if (this.getPhpVersion().isLessThan(PHPVersion.PHP7_0)) {
            return false;
        }
        TextSequence statementText = this.getStatementText();
        int curr = statementText.length();
        if ((curr = PHPTextSequenceUtilities.readBackwardSpaces(statementText, curr)) < 1) {
            return false;
        }
        if ((curr = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, curr, false)) < 1) {
            return false;
        }
        return (curr = PHPTextSequenceUtilities.readBackwardSpaces(statementText, curr)) > 0 && statementText.charAt(curr - 1) == ':';
    }
}

