/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ForEachStatement
extends Statement {
    private Expression expression;
    private Expression key;
    private Expression value;
    private Statement statement;
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(ForEachStatement.class, "expression", Expression.class, true, true);
    public static final ChildPropertyDescriptor KEY_PROPERTY = new ChildPropertyDescriptor(ForEachStatement.class, "key", Expression.class, false, true);
    public static final ChildPropertyDescriptor VALUE_PROPERTY = new ChildPropertyDescriptor(ForEachStatement.class, "value", Expression.class, true, true);
    public static final ChildPropertyDescriptor STATEMENT_PROPERTY = new ChildPropertyDescriptor(ForEachStatement.class, "statement", Statement.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> propertyList = new ArrayList<ChildPropertyDescriptor>(1);
        propertyList.add(EXPRESSION_PROPERTY);
        propertyList.add(KEY_PROPERTY);
        propertyList.add(VALUE_PROPERTY);
        propertyList.add(STATEMENT_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public ForEachStatement(int start, int end, AST ast, Expression expression, Expression key, Expression value, Statement statement) {
        super(start, end, ast);
        if (expression == null || value == null || statement == null) {
            throw new IllegalArgumentException();
        }
        this.setExpression(expression);
        this.setValue(value);
        this.setStatement(statement);
        if (key != null) {
            this.setKey(key);
        }
    }

    public ForEachStatement(AST ast) {
        super(ast);
    }

    public ForEachStatement(int start, int end, AST ast, Expression expression, Expression value, Statement statement) {
        this(start, end, ast, expression, null, value, statement);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.expression.accept(visitor);
        if (this.key != null) {
            this.key.accept(visitor);
        }
        this.value.accept(visitor);
        this.statement.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expression.traverseTopDown(visitor);
        if (this.key != null) {
            this.key.traverseTopDown(visitor);
        }
        this.value.traverseTopDown(visitor);
        this.statement.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.expression.traverseBottomUp(visitor);
        if (this.key != null) {
            this.key.traverseBottomUp(visitor);
        }
        this.value.traverseBottomUp(visitor);
        this.statement.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ForEachStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Expression>\n");
        this.expression.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Expression>\n");
        buffer.append("\t").append(tab).append("<Key>\n");
        if (this.key != null) {
            this.key.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Key>\n");
        buffer.append("\t").append(tab).append("<Value>\n");
        this.value.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Value>\n");
        this.statement.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</ForEachStatement>");
    }

    @Override
    public int getType() {
        return 26;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    public Expression getKey() {
        return this.key;
    }

    public void setKey(Expression key) {
        Expression oldChild = this.key;
        this.preReplaceChild(oldChild, key, KEY_PROPERTY);
        this.key = key;
        this.postReplaceChild(oldChild, key, KEY_PROPERTY);
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.value;
        this.preReplaceChild(oldChild, value, VALUE_PROPERTY);
        this.value = value;
        this.postReplaceChild(oldChild, value, VALUE_PROPERTY);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException();
        }
        Statement oldChild = this.statement;
        this.preReplaceChild(oldChild, statement, STATEMENT_PROPERTY);
        this.statement = statement;
        this.postReplaceChild(oldChild, statement, STATEMENT_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        if (property == KEY_PROPERTY) {
            if (get) {
                return this.getKey();
            }
            this.setKey((Expression)child);
            return null;
        }
        if (property == VALUE_PROPERTY) {
            if (get) {
                return this.getValue();
            }
            this.setValue((Expression)child);
            return null;
        }
        if (property == STATEMENT_PROPERTY) {
            if (get) {
                return this.getStatement();
            }
            this.setStatement((Statement)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression expr = ASTNode.copySubtree(target, this.getExpression());
        Expression key = ASTNode.copySubtree(target, this.getKey());
        Expression value = ASTNode.copySubtree(target, this.getValue());
        Statement stm = ASTNode.copySubtree(target, this.getStatement());
        ForEachStatement result = new ForEachStatement(this.getStart(), this.getEnd(), target, expr, key, value, stm);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

