/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ArrayElement
extends ASTNode {
    private Expression key;
    private Expression value;
    public static final ChildPropertyDescriptor KEY_PROPERTY = new ChildPropertyDescriptor(ArrayElement.class, "key", Expression.class, false, true);
    public static final ChildPropertyDescriptor VALUE_PROPERTY = new ChildPropertyDescriptor(ArrayElement.class, "value", Expression.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> properyList = new ArrayList<ChildPropertyDescriptor>(3);
        properyList.add(KEY_PROPERTY);
        properyList.add(VALUE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public ArrayElement(AST ast) {
        super(ast);
    }

    public ArrayElement(int start, int end, AST ast, Expression key, Expression value) {
        super(start, end, ast);
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.setValue(value);
        if (key != null) {
            this.setKey(key);
        }
    }

    public ArrayElement(int start, int end, AST ast, Expression value) {
        this(start, end, ast, null, value);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        if (this.key != null) {
            this.key.accept(visitor);
        }
        this.value.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.key != null) {
            this.key.traverseTopDown(visitor);
        }
        this.value.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        if (this.key != null) {
            this.key.traverseBottomUp(visitor);
        }
        this.value.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ArrayElement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Key>\n");
        if (this.key != null) {
            this.key.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Key>\n");
        buffer.append("\t").append(tab).append("<Value>\n");
        this.value.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Value>\n");
        buffer.append(tab).append("</ArrayElement>");
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public int getType() {
        return 2;
    }

    public Expression getKey() {
        return this.key;
    }

    public void setKey(Expression expression) {
        Expression oldChild = this.key;
        this.preReplaceChild(oldChild, expression, KEY_PROPERTY);
        this.key = expression;
        this.postReplaceChild(oldChild, expression, KEY_PROPERTY);
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.value;
        this.preReplaceChild(oldChild, expression, VALUE_PROPERTY);
        this.value = expression;
        this.postReplaceChild(oldChild, expression, VALUE_PROPERTY);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression key = ASTNode.copySubtree(target, this.getKey());
        Expression value = ASTNode.copySubtree(target, this.getValue());
        ArrayElement result = new ArrayElement(this.getStart(), this.getEnd(), target, key, value);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == KEY_PROPERTY) {
            if (get) {
                return this.getKey();
            }
            this.setKey((Expression)child);
            return null;
        }
        if (property == VALUE_PROPERTY) {
            if (get) {
                return this.getValue();
            }
            this.setValue((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }
}

