/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class AnonymousClassDeclaration
extends Expression {
    private Expression superClass;
    protected ASTNode.NodeList<Identifier> interfaces = new ASTNode.NodeList(this, INTERFACES_PROPERTY);
    private Block body;
    public static final ChildPropertyDescriptor SUPER_CLASS_PROPERTY = new ChildPropertyDescriptor(AnonymousClassDeclaration.class, "superClass", Expression.class, false, false);
    public static final ChildListPropertyDescriptor INTERFACES_PROPERTY = new ChildListPropertyDescriptor(AnonymousClassDeclaration.class, "interfaces", Identifier.class, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(AnonymousClassDeclaration.class, "body", Block.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(3);
        propertyList.add(SUPER_CLASS_PROPERTY);
        propertyList.add(INTERFACES_PROPERTY);
        propertyList.add(BODY_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public AnonymousClassDeclaration(AST ast) {
        super(ast);
    }

    public AnonymousClassDeclaration(int start, int end, AST ast, Expression superClass, List<Identifier> interfaces, Block body) {
        super(start, end, ast);
        this.setSuperClass(superClass);
        if (interfaces != null) {
            Iterator<Identifier> iterator = interfaces.iterator();
            while (iterator.hasNext()) {
                this.interfaces.add(iterator.next());
            }
        }
        this.setBody(body);
    }

    public Block getBody() {
        return this.body;
    }

    public Expression getSuperClass() {
        return this.superClass;
    }

    public List<Identifier> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        if (this.superClass != null) {
            this.superClass.accept(visitor);
        }
        if (this.interfaces != null) {
            for (Identifier identifier : this.interfaces) {
                identifier.accept(visitor);
            }
        }
        this.body.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        if (this.superClass != null) {
            this.superClass.traverseTopDown(visitor);
        }
        if (this.interfaces != null) {
            for (Identifier identifier : this.interfaces) {
                identifier.traverseTopDown(visitor);
            }
        }
        this.body.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        if (this.superClass != null) {
            this.superClass.traverseTopDown(visitor);
        }
        if (this.interfaces != null) {
            for (Identifier identifier : this.interfaces) {
                identifier.traverseTopDown(visitor);
            }
        }
        this.body.traverseTopDown(visitor);
    }

    @Override
    void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<AnonymousClassDeclaration");
        this.appendInterval(buffer);
        buffer.append("'>\n");
        buffer.append("\t").append(tab).append("<SuperClass>\n");
        if (this.superClass != null) {
            this.superClass.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("<SuperClass>\n");
        buffer.append("\t").append(tab).append("<Interfaces>\n");
        if (this.interfaces != null) {
            for (Identifier identifier : this.interfaces) {
                identifier.toString(buffer, "\t\t" + tab);
                buffer.append("\n");
            }
        }
        buffer.append("\t").append(tab).append("<Interfaces>\n");
        buffer.append("\t").append(tab).append("<Body>\n");
        if (this.body != null) {
            this.body.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("<Body>\n");
        buffer.append(tab).append("</AnonymousClassDeclaration>");
    }

    public void setBody(Block body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        Block oldChild = this.body;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.body = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    public void setSuperClass(Expression superClass) {
        Expression oldChild = this.superClass;
        this.preReplaceChild(oldChild, superClass, SUPER_CLASS_PROPERTY);
        this.superClass = superClass;
        this.postReplaceChild(oldChild, superClass, SUPER_CLASS_PROPERTY);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression superClass = ASTNode.copySubtree(target, this.getSuperClass());
        List interfaces = ASTNode.copySubtrees(target, this.getInterfaces());
        Block body = ASTNode.copySubtree(target, this.getBody());
        return new AnonymousClassDeclaration(this.getStart(), this.getEnd(), target, superClass, interfaces, body);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        if (property == SUPER_CLASS_PROPERTY) {
            if (get) {
                return this.getSuperClass();
            }
            this.setSuperClass((Identifier)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == INTERFACES_PROPERTY) {
            return this.getInterfaces();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    public int getType() {
        return 77;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

