/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.examples.logo.handlers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Map;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Paint;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.common.collections.ObservableMultiset;
import org.eclipse.gef.fx.internal.nodes.IBendableCurve;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.examples.logo.MvcLogoExample;
import org.eclipse.gef.mvc.examples.logo.model.GeometricCurve;
import org.eclipse.gef.mvc.examples.logo.parts.GeometricCurvePart;
import org.eclipse.gef.mvc.examples.logo.parts.GeometricShapePart;
import org.eclipse.gef.mvc.fx.gestures.ClickDragGesture;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnDragHandler;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.operations.DeselectOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.CircleSegmentHandlePart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.CreationPolicy;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class CreateCurveOnDragHandler
extends AbstractHandler
implements IOnDragHandler {
    private CircleSegmentHandlePart bendTargetPart;
    private Map<AdapterKey<? extends IOnDragHandler>, IOnDragHandler> dragPolicies;
    private GeometricCurvePart<? extends Node, ? extends Node, ? extends Node> curvePart;

    public void abortDrag() {
        if (this.bendTargetPart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.abortDrag();
            }
        }
        this.restoreRefreshVisuals((IVisualPart)this.curvePart);
        this.curvePart = null;
        this.bendTargetPart = null;
        this.dragPolicies = null;
    }

    public void drag(MouseEvent event, Dimension delta) {
        if (this.bendTargetPart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.drag(event, delta);
            }
        }
    }

    public void endDrag(MouseEvent e, Dimension delta) {
        if (this.bendTargetPart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.endDrag(e, delta);
            }
        }
        this.restoreRefreshVisuals((IVisualPart)this.curvePart);
        this.curvePart = null;
        this.bendTargetPart = null;
        this.dragPolicies = null;
    }

    protected CircleSegmentHandlePart findBendTargetPart(GeometricCurvePart<?, ?, ?> curvePart, EventTarget eventTarget) {
        ObservableMultiset anchoreds = curvePart.getAnchoredsUnmodifiable();
        for (IVisualPart anchored : anchoreds) {
            CircleSegmentHandlePart circleSegmentHandlePart;
            if (!(anchored instanceof CircleSegmentHandlePart) || (circleSegmentHandlePart = (CircleSegmentHandlePart)anchored).getSegmentParameter() != 1.0) continue;
            return circleSegmentHandlePart;
        }
        throw new IllegalStateException("Cannot find bend target part.");
    }

    protected Point getLocation(MouseEvent e) {
        if (this.getHost().getViewer() == null) {
            return new Point(e.getSceneX(), e.getSceneY());
        }
        Point2D location = ((InfiniteCanvasViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentGroup().sceneToLocal(e.getSceneX(), e.getSceneY());
        return new Point(location.getX(), location.getY());
    }

    protected GeometricShapePart getShapePart() {
        return (GeometricShapePart)((Object)this.getHost().getAnchoragesUnmodifiable().keySet().iterator().next());
    }

    public void hideIndicationCursor() {
    }

    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    public void startDrag(MouseEvent event) {
        GeometricCurve curve = new GeometricCurve(new Point[]{new Point(), new Point()}, (Paint)MvcLogoExample.GEF_COLOR_GREEN, 3.5, MvcLogoExample.GEF_DASH_PATTERN, null, GeometricCurve.RoutingStyle.STRAIGHT, GeometricCurve.InterpolationStyle.POLYBEZIER);
        curve.addSourceAnchorage(this.getShapePart().getContent());
        CreationPolicy creationPolicy = (CreationPolicy)this.getHost().getRoot().getAdapter(CreationPolicy.class);
        this.init((IPolicy)creationPolicy);
        this.curvePart = (GeometricCurvePart)creationPolicy.create((Object)curve, (IVisualPart)this.getHost().getRoot(), (SetMultimap)HashMultimap.create());
        this.commit((IPolicy)creationPolicy);
        this.storeAndDisableRefreshVisuals((IVisualPart)this.curvePart);
        ((IBendableCurve)this.curvePart.getVisual()).setEndPoint(this.getLocation(event));
        ArrayList toBeDeselected = new ArrayList(((SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class)).getSelectionUnmodifiable());
        toBeDeselected.remove(this.curvePart);
        DeselectOperation deselectOperation = new DeselectOperation(this.getHost().getRoot().getViewer(), toBeDeselected);
        try {
            this.getHost().getRoot().getViewer().getDomain().execute((ITransactionalOperation)deselectOperation, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.bendTargetPart = this.findBendTargetPart(this.curvePart, event.getTarget());
        if (this.bendTargetPart != null) {
            this.dragPolicies = this.bendTargetPart.getAdapters(ClickDragGesture.ON_DRAG_POLICY_KEY);
        }
        if (this.dragPolicies != null) {
            MouseEvent dragEvent = new MouseEvent(event.getSource(), event.getTarget(), MouseEvent.MOUSE_DRAGGED, event.getX(), event.getY(), event.getScreenX(), event.getScreenY(), event.getButton(), event.getClickCount(), event.isShiftDown(), event.isControlDown(), event.isAltDown(), event.isMetaDown(), event.isPrimaryButtonDown(), event.isMiddleButtonDown(), event.isSecondaryButtonDown(), event.isSynthesized(), event.isPopupTrigger(), event.isStillSincePress(), event.getPickResult());
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.startDrag(event);
                dragPolicy.drag(dragEvent, new Dimension());
            }
        }
    }
}

