/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;

public final class PrecisionRectangle
extends Rectangle {
    public double preciseHeight;
    public double preciseWidth;
    public double preciseX;
    public double preciseY;

    public PrecisionRectangle() {
    }

    public PrecisionRectangle(Rectangle rect) {
        this.preciseX = rect.preciseX();
        this.preciseY = rect.preciseY();
        this.preciseWidth = rect.preciseWidth();
        this.preciseHeight = rect.preciseHeight();
        this.updateInts();
    }

    public Rectangle getCopy() {
        return this.getPreciseCopy();
    }

    public PrecisionRectangle getPreciseCopy() {
        PrecisionRectangle result = new PrecisionRectangle();
        result.preciseX = this.preciseX;
        result.preciseY = this.preciseY;
        result.preciseWidth = this.preciseWidth;
        result.preciseHeight = this.preciseHeight;
        result.updateInts();
        return result;
    }

    public Rectangle crop(Insets insets) {
        if (insets == null) {
            return this;
        }
        this.setX(this.preciseX + (double)insets.left);
        this.setY(this.preciseY + (double)insets.top);
        this.setWidth(this.preciseWidth - (double)insets.getWidth());
        this.setHeight(this.preciseHeight - (double)insets.getHeight());
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof PrecisionRectangle) {
            PrecisionRectangle pr = (PrecisionRectangle)o;
            return super.equals(o) && Math.abs(pr.preciseX - this.preciseX) < 1.0E-9 && Math.abs(pr.preciseY - this.preciseY) < 1.0E-9 && Math.abs(pr.preciseWidth - this.preciseWidth) < 1.0E-9 && Math.abs(pr.preciseHeight - this.preciseHeight) < 1.0E-8;
        }
        return super.equals(o);
    }

    public void performScale(double factor) {
        this.preciseX *= factor;
        this.preciseY *= factor;
        this.preciseWidth *= factor;
        this.preciseHeight *= factor;
        this.updateInts();
    }

    public void performTranslate(int dx, int dy) {
        this.preciseX += (double)dx;
        this.preciseY += (double)dy;
        this.x += dx;
        this.y += dy;
    }

    public double preciseBottom() {
        return this.preciseHeight + this.preciseY;
    }

    public double preciseRight() {
        return this.preciseWidth + this.preciseX;
    }

    public Rectangle resize(Dimension sizeDelta) {
        this.preciseWidth += sizeDelta.preciseWidth();
        this.preciseHeight += sizeDelta.preciseHeight();
        this.updateInts();
        return this;
    }

    public void setHeight(double value) {
        this.preciseHeight = value;
        this.height = (int)Math.floor(this.preciseHeight + 1.0E-9);
    }

    public void setWidth(double value) {
        this.preciseWidth = value;
        this.width = (int)Math.floor(this.preciseWidth + 1.0E-9);
    }

    public void setX(double value) {
        this.preciseX = value;
        this.x = (int)Math.floor(this.preciseX + 1.0E-9);
    }

    public void setY(double value) {
        this.preciseY = value;
        this.y = (int)Math.floor(this.preciseY + 1.0E-9);
    }

    public Rectangle translate(Point p) {
        this.preciseX += p.preciseX();
        this.preciseY += p.preciseY();
        this.updateInts();
        return this;
    }

    public PrecisionRectangle union(PrecisionRectangle other) {
        double newright = Math.max(this.preciseRight(), other.preciseRight());
        double newbottom = Math.max(this.preciseBottom(), other.preciseBottom());
        this.preciseX = Math.min(this.preciseX, other.preciseX);
        this.preciseY = Math.min(this.preciseY, other.preciseY);
        this.preciseWidth = newright - this.preciseX;
        this.preciseHeight = newbottom - this.preciseY;
        this.updateInts();
        return this;
    }

    public Rectangle union(Rectangle other) {
        double newright = Math.max(this.preciseRight(), other.preciseX() + other.preciseWidth());
        double newbottom = Math.max(this.preciseBottom(), other.preciseY() + other.preciseHeight());
        this.preciseX = Math.min(this.preciseX, other.preciseX());
        this.preciseY = Math.min(this.preciseY, other.preciseY());
        this.preciseWidth = newright - this.preciseX;
        this.preciseHeight = newbottom - this.preciseY;
        this.updateInts();
        return this;
    }

    public void updateInts() {
        this.x = (int)Math.floor(this.preciseX + 1.0E-9);
        this.y = (int)Math.floor(this.preciseY + 1.0E-9);
        this.width = (int)Math.floor(this.preciseWidth + this.preciseX + 1.0E-9) - this.x;
        this.height = (int)Math.floor(this.preciseHeight + this.preciseY + 1.0E-9) - this.y;
    }

    public void union(Point p) {
        if (p.preciseX() < this.preciseX) {
            this.preciseWidth += this.preciseX - p.preciseX();
            this.preciseX = p.preciseX();
        } else {
            double right = this.preciseX + this.preciseWidth;
            if (p.preciseX() > right) {
                this.preciseWidth = p.preciseX() - this.preciseX;
            }
        }
        if (p.preciseY() < this.preciseY) {
            this.preciseHeight += this.preciseY - p.preciseY();
            this.preciseY = p.preciseY();
        } else {
            double bottom = this.preciseY + this.preciseHeight;
            if (p.preciseY() > bottom) {
                this.preciseHeight = p.preciseY() - this.preciseY;
            }
        }
        this.updateInts();
    }

    public Rectangle transpose() {
        double temp = this.preciseX;
        this.preciseX = this.preciseY;
        this.preciseY = temp;
        temp = this.preciseWidth;
        this.preciseWidth = this.preciseHeight;
        this.preciseHeight = temp;
        super.transpose();
        return this;
    }

    public Rectangle setLocation(Point loc) {
        this.preciseX = loc.preciseX();
        this.preciseY = loc.preciseY();
        this.updateInts();
        return this;
    }

    public Point getCenter() {
        return new PrecisionPoint(this.preciseX + this.preciseWidth / 2.0, this.preciseY + this.preciseHeight / 2.0);
    }

    public Rectangle shrink(double h, double v) {
        this.preciseX += h;
        this.preciseWidth -= h + h;
        this.preciseY += v;
        this.preciseHeight -= v + v;
        this.updateInts();
        return this;
    }

    public Rectangle expand(double h, double v) {
        return this.shrink(-h, -v);
    }

    public Rectangle shrink(int h, int v) {
        return this.shrink((double)h, (double)v);
    }

    public boolean contains(Point p) {
        return this.preciseX <= p.preciseX() && p.preciseX() <= this.preciseX + this.preciseWidth && this.preciseY <= p.preciseY() && p.preciseY() <= this.preciseY + this.preciseHeight;
    }

    public double preciseX() {
        return this.preciseX;
    }

    public double preciseY() {
        return this.preciseY;
    }

    public double preciseWidth() {
        return this.preciseWidth;
    }

    public double preciseHeight() {
        return this.preciseHeight;
    }

    public Rectangle setSize(Dimension d) {
        this.preciseWidth = d.preciseWidth();
        this.preciseHeight = d.preciseHeight();
        return super.setSize(d);
    }
}

