/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model.commands;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicGuide;
import org.eclipse.gef.examples.logicdesigner.model.LogicRuler;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;

public class DeleteGuideCommand
extends Command {
    private LogicRuler parent;
    private LogicGuide guide;
    private Map<LogicSubpart, Integer> oldParts;

    public DeleteGuideCommand(LogicGuide guide, LogicRuler parent) {
        super(LogicMessages.DeleteGuideCommand_Label);
        this.guide = guide;
        this.parent = parent;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        this.oldParts = new HashMap<LogicSubpart, Integer>(this.guide.getMap());
        for (LogicSubpart subPart : this.oldParts.keySet()) {
            this.guide.detachPart(subPart);
        }
        this.parent.removeGuide(this.guide);
    }

    public void undo() {
        this.parent.addGuide(this.guide);
        for (LogicSubpart subPart : this.oldParts.keySet()) {
            this.guide.attachPart(subPart, this.oldParts.get(subPart));
        }
    }
}

