/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.AndGate;
import org.eclipse.gef.examples.logicdesigner.model.Circuit;
import org.eclipse.gef.examples.logicdesigner.model.GroundOutput;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.examples.logicdesigner.model.LiveOutput;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicElement;
import org.eclipse.gef.examples.logicdesigner.model.LogicFlowContainer;
import org.eclipse.gef.examples.logicdesigner.model.LogicGuide;
import org.eclipse.gef.examples.logicdesigner.model.LogicLabel;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.OrGate;
import org.eclipse.gef.examples.logicdesigner.model.Wire;
import org.eclipse.gef.examples.logicdesigner.model.WireBendpoint;
import org.eclipse.gef.examples.logicdesigner.model.XORGate;
import org.eclipse.gef.examples.logicdesigner.model.commands.ChangeGuideCommand;

public class CloneCommand
extends Command {
    private final List<LogicSubpart> parts = new LinkedList<LogicSubpart>();
    private List<LogicSubpart> newTopLevelParts;
    private List<Wire> newConnections;
    private LogicDiagram parent;
    private Map<LogicSubpart, Rectangle> bounds;
    private Map<LogicSubpart, Integer> indices;
    private Map<LogicSubpart, LogicSubpart> connectionPartMap;
    private ChangeGuideCommand vGuideCommand;
    private ChangeGuideCommand hGuideCommand;
    private LogicGuide hGuide;
    private LogicGuide vGuide;
    private int hAlignment;
    private int vAlignment;

    public CloneCommand() {
        super(LogicMessages.CloneCommand_Label);
    }

    public void addPart(LogicSubpart part, Rectangle newBounds) {
        this.parts.add(part);
        if (this.bounds == null) {
            this.bounds = new HashMap<LogicSubpart, Rectangle>();
        }
        this.bounds.put(part, newBounds);
    }

    public void addPart(LogicSubpart part, int index) {
        this.parts.add(part);
        if (this.indices == null) {
            this.indices = new HashMap<LogicSubpart, Integer>();
        }
        this.indices.put(part, index);
    }

    protected void clonePart(LogicSubpart oldPart, LogicDiagram newParent, Rectangle newBounds, List<Wire> newConnections, Map<LogicSubpart, LogicSubpart> connectionPartMap, int index) {
        LogicSubpart newPart = null;
        if (oldPart instanceof AndGate) {
            newPart = new AndGate();
        } else if (oldPart instanceof Circuit) {
            newPart = new Circuit();
        } else if (oldPart instanceof GroundOutput) {
            newPart = new GroundOutput();
        } else if (oldPart instanceof LED) {
            newPart = new LED();
            newPart.setPropertyValue((Object)"value", oldPart.getPropertyValue((Object)"value"));
        } else if (oldPart instanceof LiveOutput) {
            newPart = new LiveOutput();
        } else if (oldPart instanceof LogicLabel) {
            newPart = new LogicLabel();
            ((LogicLabel)newPart).setLabelContents(((LogicLabel)oldPart).getLabelContents());
        } else if (oldPart instanceof OrGate) {
            newPart = new OrGate();
        } else if (oldPart instanceof LogicFlowContainer) {
            newPart = new LogicFlowContainer();
        } else if (oldPart instanceof XORGate) {
            newPart = new XORGate();
        }
        if (oldPart instanceof LogicDiagram) {
            LogicDiagram ld = (LogicDiagram)oldPart;
            for (LogicElement element : ld.getChildren()) {
                this.clonePart((LogicSubpart)element, (LogicDiagram)newPart, null, newConnections, connectionPartMap, -1);
            }
        }
        for (Wire connection : oldPart.getTargetConnections()) {
            Wire newConnection = new Wire();
            newConnection.setValue(connection.getValue());
            newConnection.setTarget(newPart);
            newConnection.setTargetTerminal(connection.getTargetTerminal());
            newConnection.setSourceTerminal(connection.getSourceTerminal());
            newConnection.setSource(connection.getSource());
            newConnection.setBendpoints(CloneCommand.cloneBendPoints(connection));
            newConnections.add(newConnection);
        }
        if (index < 0) {
            newParent.addChild(newPart);
        } else {
            newParent.addChild(newPart, index);
        }
        newPart.setSize(oldPart.getSize());
        if (newBounds != null) {
            newPart.setLocation(newBounds.getTopLeft());
        } else {
            newPart.setLocation(oldPart.getLocation());
        }
        if (newParent == this.parent) {
            this.newTopLevelParts.add(newPart);
        }
        connectionPartMap.put(oldPart, newPart);
    }

    private static List<WireBendpoint> cloneBendPoints(Wire connection) {
        ArrayList<WireBendpoint> newBendPoints = new ArrayList<WireBendpoint>(connection.getBendpoints().size());
        for (WireBendpoint bendPoint : connection.getBendpoints()) {
            WireBendpoint newBendPoint = new WireBendpoint();
            newBendPoint.setRelativeDimensions(bendPoint.getFirstRelativeDimension(), bendPoint.getSecondRelativeDimension());
            newBendPoint.setWeight(bendPoint.getWeight());
            newBendPoints.add(newBendPoint);
        }
        return newBendPoints;
    }

    public void execute() {
        this.connectionPartMap = new HashMap<LogicSubpart, LogicSubpart>();
        this.newConnections = new LinkedList<Wire>();
        this.newTopLevelParts = new LinkedList<LogicSubpart>();
        for (LogicSubpart part : this.parts) {
            if (this.bounds != null && this.bounds.containsKey(part)) {
                this.clonePart(part, this.parent, this.bounds.get(part), this.newConnections, this.connectionPartMap, -1);
                continue;
            }
            if (this.indices != null && this.indices.containsKey(part)) {
                this.clonePart(part, this.parent, null, this.newConnections, this.connectionPartMap, this.indices.get(part));
                continue;
            }
            this.clonePart(part, this.parent, null, this.newConnections, this.connectionPartMap, -1);
        }
        for (Wire conn : this.newConnections) {
            LogicSubpart source = conn.getSource();
            if (!this.connectionPartMap.containsKey(source)) continue;
            conn.setSource(this.connectionPartMap.get(source));
            conn.attachSource();
            conn.attachTarget();
        }
        if (this.hGuide != null) {
            this.hGuideCommand = new ChangeGuideCommand(this.connectionPartMap.get(this.parts.get(0)), true);
            this.hGuideCommand.setNewGuide(this.hGuide, this.hAlignment);
            this.hGuideCommand.execute();
        }
        if (this.vGuide != null) {
            this.vGuideCommand = new ChangeGuideCommand(this.connectionPartMap.get(this.parts.get(0)), false);
            this.vGuideCommand.setNewGuide(this.vGuide, this.vAlignment);
            this.vGuideCommand.execute();
        }
    }

    public void setParent(LogicDiagram parent) {
        this.parent = parent;
    }

    public void redo() {
        this.newTopLevelParts.forEach(nTLP -> this.parent.addChild((LogicElement)nTLP));
        for (Wire conn : this.newConnections) {
            LogicSubpart source = conn.getSource();
            if (!this.connectionPartMap.containsKey(source)) continue;
            conn.setSource(this.connectionPartMap.get(source));
            conn.attachSource();
            conn.attachTarget();
        }
        if (this.hGuideCommand != null) {
            this.hGuideCommand.redo();
        }
        if (this.vGuideCommand != null) {
            this.vGuideCommand.redo();
        }
    }

    public void setGuide(LogicGuide guide, int alignment, boolean isHorizontal) {
        if (isHorizontal) {
            this.hGuide = guide;
            this.hAlignment = alignment;
        } else {
            this.vGuide = guide;
            this.vAlignment = alignment;
        }
    }

    public void undo() {
        if (this.hGuideCommand != null) {
            this.hGuideCommand.undo();
        }
        if (this.vGuideCommand != null) {
            this.vGuideCommand.undo();
        }
        this.newTopLevelParts.forEach(nTLP -> this.parent.removeChild((LogicElement)nTLP));
    }
}

