/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.examples.logicdesigner.figures.LogicColorConstants;

public class LogicFlowBorder
extends LineBorder {
    protected int grabBarWidth = 40;
    protected Dimension grabBarSize = new Dimension(this.grabBarWidth, 36);
    private static final int CORNER_RADIUS = 8;

    public LogicFlowBorder() {
    }

    public LogicFlowBorder(int width) {
        this.setGrabBarWidth(width);
        this.grabBarSize = new Dimension(width, 36);
    }

    public Insets getInsets(IFigure figure) {
        return new Insets(this.getWidth() + 4, this.grabBarWidth + 4, this.getWidth() + 4, this.getWidth() + 4);
    }

    public Dimension getPreferredSize() {
        return this.grabBarSize;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Rectangle bounds = figure.getBounds();
        graphics.setLineWidth(4);
        Rectangle grabBar = new Rectangle(bounds.x, bounds.y, this.grabBarWidth, bounds.height);
        graphics.setBackgroundColor(LogicColorConstants.logicGreen);
        graphics.fillRoundRectangle(grabBar, 8, 8);
        Rectangle rightPart = grabBar.getCopy();
        rightPart.x += rightPart.width / 2;
        rightPart.width /= 2;
        graphics.fillRectangle(rightPart);
        Rectangle mainBorder = bounds.getCopy();
        --mainBorder.width;
        --mainBorder.height;
        graphics.setForegroundColor(LogicColorConstants.logicGreen);
        graphics.drawRoundRectangle(mainBorder, 8, 8);
    }

    public void setGrabBarWidth(int width) {
        this.grabBarWidth = width;
    }
}

