/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicElement;
import org.eclipse.gef.examples.logicdesigner.model.LogicRuler;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class LogicDiagram
extends LogicSubpart {
    static final long serialVersionUID = 1L;
    public static final String ID_ROUTER = "router";
    public static final Integer ROUTER_MANUAL = 0;
    public static final Integer ROUTER_MANHATTAN = 1;
    public static final Integer ROUTER_SHORTEST_PATH = 2;
    private static int count;
    private static final Image LOGIC_ICON;
    private final List<LogicElement> children = new ArrayList<LogicElement>();
    private LogicRuler leftRuler;
    private LogicRuler topRuler;
    private Integer connectionRouter = null;
    private boolean rulersVisibility = false;
    private boolean snapToGeometry = false;
    private boolean gridEnabled = false;
    private double zoom = 1.0;

    static {
        LOGIC_ICON = LogicDiagram.createImage(LogicDiagram.class, "icons/circuit16.gif");
    }

    public LogicDiagram() {
        this.size.width = 200;
        this.size.height = 200;
        this.location.x = 40;
        this.location.y = 40;
        this.createRulers();
    }

    public void addChild(LogicElement child) {
        this.addChild(child, -1);
    }

    public void addChild(LogicElement child, int index) {
        if (index >= 0) {
            this.children.add(index, child);
        } else {
            this.children.add(child);
        }
        this.fireChildAdded("Children", child, index);
    }

    protected void createRulers() {
        this.leftRuler = new LogicRuler(false);
        this.topRuler = new LogicRuler(true);
    }

    public List<LogicElement> getChildren() {
        return this.children;
    }

    public Integer getConnectionRouter() {
        if (this.connectionRouter == null) {
            this.connectionRouter = ROUTER_MANUAL;
        }
        return this.connectionRouter;
    }

    @Override
    public Image getIconImage() {
        return LOGIC_ICON;
    }

    @Override
    public String getNewID() {
        return Integer.toString(count++);
    }

    public double getZoom() {
        return this.zoom;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.getClass().equals(LogicDiagram.class)) {
            ComboBoxPropertyDescriptor cbd = new ComboBoxPropertyDescriptor((Object)ID_ROUTER, LogicMessages.PropertyDescriptor_LogicDiagram_ConnectionRouter, new String[]{LogicMessages.PropertyDescriptor_LogicDiagram_Manual, LogicMessages.PropertyDescriptor_LogicDiagram_Manhattan, LogicMessages.PropertyDescriptor_LogicDiagram_ShortestPath});
            cbd.setLabelProvider((ILabelProvider)new ConnectionRouterLabelProvider());
            return new IPropertyDescriptor[]{cbd};
        }
        return super.getPropertyDescriptors();
    }

    @Override
    public Object getPropertyValue(Object propName) {
        if (propName.equals(ID_ROUTER)) {
            return this.connectionRouter;
        }
        return super.getPropertyValue(propName);
    }

    public LogicRuler getRuler(int orientation) {
        LogicRuler result = null;
        switch (orientation) {
            case 1: {
                result = this.topRuler;
                break;
            }
            case 8: {
                result = this.leftRuler;
            }
        }
        return result;
    }

    public boolean getRulerVisibility() {
        return this.rulersVisibility;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public boolean isSnapToGeometryEnabled() {
        return this.snapToGeometry;
    }

    public void removeChild(LogicElement child) {
        this.children.remove(child);
        this.fireChildRemoved("Children", child);
    }

    public void setConnectionRouter(Integer router) {
        Integer oldConnectionRouter = this.connectionRouter;
        this.connectionRouter = router;
        this.firePropertyChange(ID_ROUTER, oldConnectionRouter, this.connectionRouter);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (ID_ROUTER.equals(id)) {
            this.setConnectionRouter((Integer)value);
        } else {
            super.setPropertyValue(id, value);
        }
    }

    public void setRulerVisibility(boolean newValue) {
        this.rulersVisibility = newValue;
    }

    public void setGridEnabled(boolean isEnabled) {
        this.gridEnabled = isEnabled;
    }

    public void setSnapToGeometry(boolean isEnabled) {
        this.snapToGeometry = isEnabled;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public String toString() {
        return LogicMessages.LogicDiagram_LabelText;
    }

    private static class ConnectionRouterLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof Integer) {
                Integer integer = (Integer)element;
                if (ROUTER_MANUAL.intValue() == integer.intValue()) {
                    return LogicMessages.PropertyDescriptor_LogicDiagram_Manual;
                }
                if (ROUTER_MANHATTAN.intValue() == integer.intValue()) {
                    return LogicMessages.PropertyDescriptor_LogicDiagram_Manhattan;
                }
                if (ROUTER_SHORTEST_PATH.intValue() == integer.intValue()) {
                    return LogicMessages.PropertyDescriptor_LogicDiagram_ShortestPath;
                }
            }
            return super.getText(element);
        }
    }
}

