/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AddressRangePosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyPosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.LabelPosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.SourcePosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;

public class DisassemblyTextHover
implements ITextHover {
    private final DisassemblyPart fDisassemblyPart;

    public DisassemblyTextHover(DisassemblyPart part) {
        this.fDisassemblyPart = part;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IDocument doc = textViewer.getDocument();
        return CWordFinder.findWord((IDocument)doc, (int)offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        block9: {
            DisassemblyDocument doc = (DisassemblyDocument)textViewer.getDocument();
            int offset = hoverRegion.getOffset();
            try {
                String ident = doc.get(offset, hoverRegion.getLength());
                String value = null;
                AddressRangePosition pos = doc.getModelPosition(offset);
                value = this.fDisassemblyPart.getHoverInfoData(pos, ident);
                if (value == null || value.length() == 0) {
                    if (pos instanceof SourcePosition) {
                        value = this.evaluateExpression(ident);
                    } else if (pos instanceof LabelPosition) {
                        value = this.evaluateExpression(ident);
                    } else if (pos instanceof DisassemblyPosition && (value = this.evaluateRegister(ident)) == null) {
                        value = this.evaluateExpression(ident);
                    }
                    if (value != null) {
                        return ident + " = " + value;
                    }
                    break block9;
                }
                return value;
            }
            catch (BadLocationException e) {
                if (!DsfUIPlugin.getDefault().isDebugging()) break block9;
                DsfUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", "Internal Error", (Throwable)e));
            }
        }
        return null;
    }

    private String evaluateRegister(String register) {
        return this.fDisassemblyPart.evaluateRegister(register);
    }

    private String evaluateExpression(String expr) {
        return this.fDisassemblyPart.evaluateExpression(expr);
    }
}

