/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AbstractMakefile;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeConfigMacro;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakefileUtil;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.BadDirective;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Command;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Comment;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Conditional;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.DefaultRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.DefineVariable;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.DeleteOnErrorRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Directive;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Else;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.EmptyLine;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Endef;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Endif;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.ExportAllVariablesRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.ExportVariable;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.GNUMakefileUtil;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.GNUTargetRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.GNUVariableDef;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IAutomakeConditional;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.If;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Ifdef;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Ifeq;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Ifndef;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Ifneq;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IgnoreRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Include;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.InferenceRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IntermediateRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.LowResolutionTimeRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.MacroDefinition;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.MakefileReader;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.NotParallelRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.OverrideDefine;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.OverrideVariable;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.PhonyRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.PosixMakefileUtil;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.PosixRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.PreciousRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Rule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.SccsGetRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.SecondaryRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.SilentRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.SpecialRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.StaticTargetRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.SuffixesRule;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Target;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.TargetVariable;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.UnExport;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.Util;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.VPath;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.IAutomaticVariable;
import org.eclipse.cdt.make.core.makefile.IBuiltinFunction;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.gnu.IGNUMakefile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class GNUAutomakefile
extends AbstractMakefile
implements IGNUMakefile {
    public static final String PATH_SEPARATOR = System.getProperty("path.separator", ":");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator", "/");
    String[] includeDirectories = new String[0];
    IDirective[] builtins = null;

    public GNUAutomakefile() {
        super(null);
    }

    public void parse(String name) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileReader stream = new FileReader(name);){
            this.parse(name, (Reader)stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void parse(String filePath, Reader reader) throws IOException {
        this.parse(URIUtil.toURI((String)filePath), new MakefileReader(reader));
    }

    public void parse(URI fileURI, Reader reader) throws IOException {
        this.parse(fileURI, new MakefileReader(reader));
    }

    protected void parse(URI fileURI, MakefileReader reader) throws IOException {
        String line;
        Rule[] rules = null;
        Stack<IDirective> conditions = new Stack<IDirective>();
        Stack<GNUVariableDef> defines = new Stack<GNUVariableDef>();
        int startLine = 0;
        int endLine = 0;
        this.clearDirectives();
        this.setFileURI(fileURI);
        while ((line = reader.readLine()) != null) {
            AutomakeConfigMacro macro;
            int i;
            int i2;
            int pound;
            startLine = endLine + 1;
            endLine = reader.getLineNumber();
            if (GNUMakefileUtil.isEndef(line)) {
                if (!defines.empty()) {
                    GNUVariableDef def = (GNUVariableDef)defines.pop();
                    def.setEndLine(endLine);
                }
                Endef endef = new Endef(this);
                endef.setLines(startLine, endLine);
                this.addDirective(conditions, endef);
                continue;
            }
            if (GNUMakefileUtil.isDefine(line)) {
                GNUVariableDef def = this.parseGNUVariableDef(line);
                def.setLines(startLine, endLine);
                this.addDirective(conditions, def);
                defines.push(def);
                continue;
            }
            if (GNUMakefileUtil.isOverrideDefine(line)) {
                GNUVariableDef oDef = this.parseGNUVariableDef(line);
                oDef.setLines(startLine, endLine);
                this.addDirective(conditions, oDef);
                defines.push(oDef);
                continue;
            }
            if (!defines.empty()) {
                GNUVariableDef def = (GNUVariableDef)defines.peek();
                StringBuffer sb = def.getValue();
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(line);
                continue;
            }
            if (PosixMakefileUtil.isCommand(line) || AutomakefileUtil.isAutomakeCommand(line)) {
                Command cmd = new Command(this, line);
                cmd.setLines(startLine, endLine);
                if (rules != null) {
                    int i3 = 0;
                    while (i3 < rules.length) {
                        rules[i3].addDirective(cmd);
                        rules[i3].setEndLine(endLine);
                        ++i3;
                    }
                    continue;
                }
                if (!conditions.isEmpty()) {
                    this.addDirective(conditions, cmd);
                    continue;
                }
            }
            if ((pound = Util.indexOfComment(line)) != -1) {
                Comment cmt = new Comment(this, line.substring(pound + 1));
                cmt.setLines(startLine, endLine);
                if (rules != null) {
                    i2 = 0;
                    while (i2 < rules.length) {
                        rules[i2].addDirective(cmt);
                        rules[i2].setEndLine(endLine);
                        ++i2;
                    }
                } else {
                    this.addDirective(conditions, cmt);
                }
                line = line.substring(0, pound);
                if (line.trim().isEmpty()) continue;
            }
            if (line.trim().isEmpty()) {
                EmptyLine empty = new EmptyLine(this);
                empty.setLines(startLine, endLine);
                if (rules != null) {
                    i2 = 0;
                    while (i2 < rules.length) {
                        rules[i2].addDirective(empty);
                        rules[i2].setEndLine(endLine);
                        ++i2;
                    }
                    continue;
                }
                this.addDirective(conditions, empty);
                continue;
            }
            if (GNUMakefileUtil.isIf(line)) {
                If ifDirective = this.parseIf(line, rules);
                ifDirective.setLines(startLine, endLine);
                if (rules != null) {
                    i2 = 0;
                    while (i2 < rules.length) {
                        rules[i2].addDirective(ifDirective);
                        rules[i2].setEndLine(endLine);
                        ++i2;
                    }
                } else {
                    this.addDirective(conditions, ifDirective);
                }
                conditions.push(ifDirective);
                rules = null;
                continue;
            }
            if (GNUMakefileUtil.isElse(line)) {
                Else elseDirective = (Else)this.parseConditional(line);
                elseDirective.setLines(startLine, endLine);
                Conditional cond = null;
                if (!conditions.empty()) {
                    cond = (Conditional)conditions.pop();
                    cond.setEndLine(endLine - 1);
                }
                if (cond != null && cond.isIf()) {
                    elseDirective.setAutomake(true);
                    rules = ((If)cond).getRules();
                    elseDirective.setRules(rules);
                    if (rules != null) {
                        int i4 = 0;
                        while (i4 < rules.length) {
                            rules[i4].addDirective(elseDirective);
                            rules[i4].setEndLine(endLine);
                            ++i4;
                        }
                    } else {
                        this.addDirective(conditions, elseDirective);
                    }
                    rules = null;
                } else {
                    this.addDirective(conditions, elseDirective);
                }
                conditions.push(elseDirective);
                continue;
            }
            if (GNUMakefileUtil.isEndif(line)) {
                Endif endif = new Endif(this);
                endif.setLines(startLine, endLine);
                Conditional cond = null;
                if (!conditions.empty()) {
                    cond = (Conditional)conditions.pop();
                    cond.setEndLine(endLine);
                }
                if (cond instanceof IAutomakeConditional) {
                    rules = ((IAutomakeConditional)((Object)cond)).getRules();
                }
                if (rules != null) {
                    int i5 = 0;
                    while (i5 < rules.length) {
                        rules[i5].addDirective(endif);
                        rules[i5].setEndLine(endLine);
                        ++i5;
                    }
                    continue;
                }
                this.addDirective(conditions, endif);
                continue;
            }
            rules = null;
            Directive directive = this.processConditions(line);
            if (directive != null) {
                directive.setLines(startLine, endLine);
                this.addDirective(conditions, directive);
                conditions.push(directive);
                continue;
            }
            directive = this.processGNUDirectives(line);
            if (directive != null) {
                directive.setLines(startLine, endLine);
                this.addDirective(conditions, directive);
                continue;
            }
            SpecialRule special = this.processSpecialRules(line);
            if (special != null) {
                rules = new Rule[]{special};
                special.setLines(startLine, endLine);
                this.addDirective(conditions, special);
                continue;
            }
            if (PosixMakefileUtil.isInferenceRule(line)) {
                InferenceRule irule = this.parseInferenceRule(line);
                irule.setLines(startLine, endLine);
                this.addDirective(conditions, irule);
                rules = new Rule[]{irule};
                continue;
            }
            if (GNUMakefileUtil.isVariableDefinition(line)) {
                GNUVariableDef vd = this.parseGNUVariableDef(line);
                vd.setLines(startLine, endLine);
                this.addDirective(conditions, vd);
                if (!vd.isTargetSpecific()) continue;
            }
            if (GNUMakefileUtil.isStaticTargetRule(line)) {
                StaticTargetRule[] srules = this.parseStaticTargetRule(line);
                i = 0;
                while (i < srules.length) {
                    srules[i].setLines(startLine, endLine);
                    this.addDirective(conditions, srules[i]);
                    ++i;
                }
                rules = srules;
                continue;
            }
            if (GNUMakefileUtil.isGNUTargetRule(line)) {
                GNUTargetRule[] trules = this.parseGNUTargetRules(line);
                i = 0;
                while (i < trules.length) {
                    trules[i].setLines(startLine, endLine);
                    this.addDirective(conditions, trules[i]);
                    ++i;
                }
                rules = trules;
                continue;
            }
            if (AutomakefileUtil.isConfigMacro(line) && (macro = this.parseConfigMacro(line)) != null) {
                macro.setLines(startLine, endLine);
                this.addDirective(macro);
                continue;
            }
            BadDirective stmt = new BadDirective(this, line);
            stmt.setLines(startLine, endLine);
            this.addDirective(conditions, stmt);
        }
        this.setLines(1, endLine);
    }

    private void addDirective(Stack<IDirective> conditions, Directive directive) {
        if (conditions.empty()) {
            this.addDirective(directive);
        } else {
            Conditional cond = (Conditional)conditions.peek();
            cond.addDirective(directive);
            cond.setEndLine(directive.getEndLine());
        }
    }

    protected Conditional processConditions(String line) {
        Conditional stmt = null;
        if (GNUMakefileUtil.isIfdef(line)) {
            stmt = this.parseConditional(line);
        } else if (GNUMakefileUtil.isIfndef(line)) {
            stmt = this.parseConditional(line);
        } else if (GNUMakefileUtil.isIfeq(line)) {
            stmt = this.parseConditional(line);
        } else if (GNUMakefileUtil.isIfneq(line)) {
            stmt = this.parseConditional(line);
        }
        return stmt;
    }

    protected Directive processGNUDirectives(String line) {
        Directive stmt = null;
        if (GNUMakefileUtil.isUnExport(line)) {
            stmt = this.parseUnExport(line);
        } else if (GNUMakefileUtil.isVPath(line)) {
            stmt = this.parseVPath(line);
        } else if (GNUMakefileUtil.isInclude(line)) {
            stmt = this.parseInclude(line);
        }
        return stmt;
    }

    protected SpecialRule processSpecialRules(String line) {
        SpecialRule stmt = null;
        if (PosixMakefileUtil.isIgnoreRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isPosixRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isPreciousRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isSilentRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isSuffixesRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isDefaultRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isSccsGetRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isPhonyRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isIntermediateRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isSecondaryRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isDeleteOnErrorRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isLowResolutionTimeRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isExportAllVariablesRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isNotParallelRule(line)) {
            stmt = this.parseSpecialRule(line);
        }
        return stmt;
    }

    protected SpecialRule parseSpecialRule(String line) {
        line = line.trim();
        String keyword = null;
        String[] reqs = null;
        SpecialRule special = null;
        int index = Util.indexOf(line, ':');
        if (index != -1) {
            keyword = line.substring(0, index).trim();
            String req = line.substring(index + 1);
            reqs = PosixMakefileUtil.findPrerequisites(req);
        } else {
            keyword = line;
            reqs = new String[]{};
        }
        if (keyword.equals(".IGNORE")) {
            special = new IgnoreRule((Directive)this, reqs);
        } else if (keyword.equals(".POSIX")) {
            special = new PosixRule(this);
        } else if (keyword.equals(".PRECIOUS")) {
            special = new PreciousRule((Directive)this, reqs);
        } else if (keyword.equals(".SILENT")) {
            special = new SilentRule((Directive)this, reqs);
        } else if (keyword.equals(".SUFFIXES")) {
            special = new SuffixesRule((Directive)this, reqs);
        } else if (keyword.equals(".DEFAULT")) {
            special = new DefaultRule((Directive)this, new Command[0]);
        } else if (keyword.equals(".SCCS_GET")) {
            special = new SccsGetRule((Directive)this, new Command[0]);
        } else if (keyword.equals(".PHONY")) {
            special = new PhonyRule((Directive)this, reqs);
        } else if (keyword.equals(".INTERMEDIATE")) {
            special = new IntermediateRule((Directive)this, reqs);
        } else if (keyword.equals(".SECONDARY")) {
            special = new SecondaryRule((Directive)this, reqs);
        } else if (keyword.equals(".DELETE_ON_ERROR")) {
            special = new DeleteOnErrorRule((Directive)this, reqs);
        } else if (keyword.equals(".LOW_RESOLUTION_TIME")) {
            special = new LowResolutionTimeRule((Directive)this, reqs);
        } else if (keyword.equals(".EXPORT_ALL_VARIABLES")) {
            special = new ExportAllVariablesRule((Directive)this, reqs);
        } else if (keyword.equals(".NOTPARALLEL")) {
            special = new NotParallelRule((Directive)this, reqs);
        }
        return special;
    }

    protected If parseIf(String line, Rule[] rules) {
        line = line.trim();
        String keyword = null;
        int i = 0;
        while (i < line.length()) {
            if (Util.isSpace(line.charAt(i))) {
                keyword = line.substring(0, i);
                line = line.substring(i).trim();
                break;
            }
            ++i;
        }
        if (keyword == null) {
            keyword = line;
        }
        if (keyword.equals("if") || keyword.equals("@if")) {
            return new If(this, rules, line);
        }
        return null;
    }

    protected Conditional parseConditional(String line) {
        Conditional condition = null;
        line = line.trim();
        String keyword = null;
        int i = 0;
        while (i < line.length()) {
            if (Util.isSpace(line.charAt(i))) {
                keyword = line.substring(0, i);
                line = line.substring(i).trim();
                break;
            }
            ++i;
        }
        if (keyword == null) {
            keyword = line;
        }
        if (keyword.equals("ifdef")) {
            condition = new Ifdef(this, line);
        } else if (keyword.equals("ifndef")) {
            condition = new Ifndef(this, line);
        } else if (keyword.equals("ifeq")) {
            condition = new Ifeq(this, line);
        } else if (keyword.equals("ifneq")) {
            condition = new Ifneq(this, line);
        } else if (keyword.equals("else")) {
            condition = new Else(this);
        }
        return condition;
    }

    protected AutomakeConfigMacro parseConfigMacro(String line) {
        String extraChars = "_-";
        char[] ch = line.toCharArray();
        int i = 1;
        while (Character.isLetterOrDigit(ch[i]) || extraChars.indexOf(ch[i]) >= 0) {
            ++i;
        }
        if (i > 1 && ch[i] == '@') {
            return new AutomakeConfigMacro(this, line.substring(0, i + 1));
        }
        return null;
    }

    protected Include parseInclude(String line) {
        String[] filenames;
        StringTokenizer st = new StringTokenizer(line);
        int count = st.countTokens();
        if (count > 0) {
            filenames = new String[count - 1];
            int i = 0;
            while (i < count) {
                if (i == 0) {
                    st.nextToken();
                } else {
                    filenames[i - 1] = st.nextToken();
                }
                ++i;
            }
        } else {
            filenames = new String[]{};
        }
        return new Include(this, filenames, this.getIncludeDirectories());
    }

    protected VPath parseVPath(String line) {
        String pattern = null;
        StringTokenizer st = new StringTokenizer(line);
        int count = st.countTokens();
        ArrayList<String> dirs = new ArrayList<String>(count);
        if (count > 0) {
            int i = 0;
            while (i < count) {
                if (count == 0) {
                    st.nextToken();
                } else if (count == 1) {
                    pattern = st.nextToken();
                } else if (count == 3) {
                    String delim = " \t\n\r\f" + PATH_SEPARATOR;
                    dirs.add(st.nextToken(delim));
                } else {
                    dirs.add(st.nextToken());
                }
                ++i;
            }
        }
        String[] directories = dirs.toArray(new String[0]);
        if (pattern == null) {
            pattern = "";
        }
        return new VPath(this, pattern, directories);
    }

    protected UnExport parseUnExport(String line) {
        int i = 0;
        while (i < line.length()) {
            if (Util.isSpace(line.charAt(i))) {
                line = line.substring(i).trim();
                break;
            }
            ++i;
        }
        return new UnExport(this, line);
    }

    protected GNUTargetRule[] parseGNUTargetRules(String line) {
        String[] orderReqs;
        String[] normalReqs;
        String[] targetNames;
        String cmd = null;
        boolean doubleColon = false;
        int index = Util.indexOf(line, ':');
        if (index != -1) {
            int semicolon;
            String target = line.substring(0, index);
            targetNames = PosixMakefileUtil.findTargets(target.trim());
            String req = line.substring(index + 1);
            doubleColon = req.startsWith(":");
            if (doubleColon) {
                req = req.substring(1);
            }
            if ((semicolon = Util.indexOf(req, ';')) != -1) {
                cmd = req.substring(semicolon + 1);
                req = req.substring(0, semicolon);
            }
            String normalReq = null;
            String orderReq = null;
            int pipe = Util.indexOf(req, '|');
            if (pipe != -1) {
                normalReq = req.substring(0, pipe);
                orderReq = req.substring(pipe + 1);
            } else {
                normalReq = req;
                orderReq = "";
            }
            normalReqs = PosixMakefileUtil.findPrerequisites(normalReq.trim());
            orderReqs = PosixMakefileUtil.findPrerequisites(orderReq.trim());
        } else {
            targetNames = PosixMakefileUtil.findTargets(line);
            normalReqs = new String[]{};
            orderReqs = new String[]{};
        }
        GNUTargetRule[] rules = new GNUTargetRule[targetNames.length];
        int i = 0;
        while (i < targetNames.length) {
            rules[i] = new GNUTargetRule(this, new Target(targetNames[i]), doubleColon, normalReqs, orderReqs, new Command[0]);
            if (cmd != null) {
                rules[i].addDirective(new Command(this, cmd));
            }
            ++i;
        }
        return rules;
    }

    protected GNUVariableDef parseGNUVariableDef(String line) {
        String name;
        int index;
        int i;
        line = line.trim();
        char type = '\u0000';
        boolean isDefine = false;
        boolean isOverride = false;
        boolean isTargetVariable = false;
        boolean isExport = false;
        String targetName = "";
        StringBuffer value = new StringBuffer();
        isTargetVariable = GNUMakefileUtil.isTargetVariable(line);
        if (isTargetVariable) {
            int colon = Util.indexOf(line, ':');
            if (colon != -1) {
                targetName = line.substring(0, colon).trim();
                line = line.substring(colon + 1).trim();
            } else {
                targetName = "";
            }
        }
        if (GNUMakefileUtil.isOverride(line)) {
            isOverride = true;
            i = 0;
            while (i < line.length()) {
                if (Util.isSpace(line.charAt(i))) {
                    line = line.substring(i).trim();
                    break;
                }
                ++i;
            }
        }
        if (GNUMakefileUtil.isDefine(line)) {
            isDefine = true;
            i = 0;
            while (i < line.length()) {
                if (Util.isSpace(line.charAt(i))) {
                    line = line.substring(i).trim();
                    break;
                }
                ++i;
            }
        }
        if (GNUMakefileUtil.isExport(line)) {
            isExport = true;
            i = 0;
            while (i < line.length()) {
                if (Util.isSpace(line.charAt(i))) {
                    line = line.substring(i).trim();
                    break;
                }
                ++i;
            }
        }
        if ((index = line.indexOf(61)) != -1) {
            int separator = index;
            if (index > 0) {
                type = line.charAt(index - 1);
                if (type == ':' || type == '+' || type == '?') {
                    separator = index - 1;
                } else {
                    type = '\u0000';
                }
            }
            name = line.substring(0, separator).trim();
            value.append(line.substring(index + 1).trim());
        } else {
            name = line;
        }
        GNUVariableDef vd = isTargetVariable ? new TargetVariable(this, targetName, name, value, isOverride, type) : (isOverride && isDefine ? new OverrideDefine(this, name, value) : (isDefine ? new DefineVariable(this, name, value) : (isOverride ? new OverrideVariable(this, name, value, type) : (isExport ? new ExportVariable(this, name, value, type) : new GNUVariableDef(this, name, value, type)))));
        return vd;
    }

    protected StaticTargetRule[] parseStaticTargetRule(String line) {
        String[] prereqPatterns;
        String targetPattern;
        String[] targets;
        int colon = Util.indexOf(line, ':');
        if (colon > 1) {
            String targetLine = line.substring(0, colon).trim();
            targets = PosixMakefileUtil.findTargets(targetLine);
            if ((colon = Util.indexOf(line = line.substring(colon + 1), ':')) != -1) {
                targetPattern = line.substring(0, colon).trim();
                line = line.substring(colon + 1);
                StringTokenizer st = new StringTokenizer(line);
                int count = st.countTokens();
                prereqPatterns = new String[count];
                int i = 0;
                while (i < count) {
                    prereqPatterns[i] = st.nextToken();
                    ++i;
                }
            } else {
                targetPattern = "";
                prereqPatterns = new String[]{};
            }
        } else {
            targets = new String[]{};
            targetPattern = "";
            prereqPatterns = new String[]{};
        }
        StaticTargetRule[] staticRules = new StaticTargetRule[targets.length];
        int i = 0;
        while (i < targets.length) {
            staticRules[i] = new StaticTargetRule(this, new Target(targets[i]), targetPattern, prereqPatterns, new Command[0]);
            ++i;
        }
        return staticRules;
    }

    protected InferenceRule parseInferenceRule(String line) {
        int index = Util.indexOf(line, ':');
        String tgt = index != -1 ? line.substring(0, index) : line;
        return new InferenceRule(this, new Target(tgt));
    }

    @Override
    public IDirective[] getDirectives(boolean expand) {
        if (!expand) {
            return this.getDirectives();
        }
        IDirective[] dirs = this.getDirectives();
        ArrayList<IDirective> list = new ArrayList<IDirective>(Arrays.asList(dirs));
        int i = 0;
        while (i < dirs.length) {
            if (dirs[i] instanceof Include) {
                Include include = (Include)dirs[i];
                IDirective[] includedMakefiles = include.getDirectives();
                int j = 0;
                while (j < includedMakefiles.length) {
                    IMakefile includedMakefile = (IMakefile)includedMakefiles[j];
                    list.addAll(Arrays.asList(includedMakefile.getDirectives()));
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new IDirective[list.size()]);
    }

    @Override
    public IDirective[] getBuiltins() {
        if (this.builtins == null) {
            Object location = "builtin" + File.separator + "gnu.mk";
            try {
                InputStream stream = FileLocator.openStream((Bundle)MakeCorePlugin.getDefault().getBundle(), (IPath)new Path((String)location), (boolean)false);
                GNUAutomakefile gnu = new GNUAutomakefile();
                URL url = FileLocator.find((Bundle)MakeCorePlugin.getDefault().getBundle(), (IPath)new Path((String)location), null);
                url = FileLocator.resolve((URL)url);
                location = url.getFile();
                gnu.parse((String)location, (Reader)new InputStreamReader(stream));
                this.builtins = gnu.getDirectives();
                int i = 0;
                while (i < this.builtins.length) {
                    if (this.builtins[i] instanceof MacroDefinition) {
                        ((MacroDefinition)this.builtins[i]).setFromDefault(true);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.builtins == null) {
                this.builtins = new IDirective[0];
            }
        }
        return (IDirective[])this.builtins.clone();
    }

    public void setIncludeDirectories(String[] dirs) {
        this.includeDirectories = (String[])dirs.clone();
    }

    public String[] getIncludeDirectories() {
        return (String[])this.includeDirectories.clone();
    }

    public static IMakefile createMakefile(IFile file) throws CoreException {
        URI fileURI = file.getLocationURI();
        GNUAutomakefile makefile = null;
        GNUAutomakefile gnu = new GNUAutomakefile();
        ArrayList<String> includeList = new ArrayList<String>();
        includeList.add(new Path(fileURI.getPath()).removeLastSegments(1).toString());
        includeList.addAll(Arrays.asList(gnu.getIncludeDirectories()));
        String[] includes = includeList.toArray(new String[includeList.size()]);
        gnu.setIncludeDirectories(includes);
        try {
            IFileStore store = EFS.getStore((URI)fileURI);
            IFileInfo info = store.fetchInfo();
            if (!info.exists() || info.isDirectory()) {
                throw new IOException();
            }
            MakefileReader reader = new MakefileReader(new InputStreamReader(store.openInputStream(0, null)));
            gnu.parse(fileURI, reader);
        }
        catch (IOException e) {
            AutotoolsUIPlugin.log(e);
            Status status = new Status(4, "org.eclipse.cdt.autotools.ui", e.getLocalizedMessage());
            throw new CoreException((IStatus)status);
        }
        makefile = gnu;
        return makefile;
    }

    public static void main(String[] args) {
        try {
            String filename = "Makefile";
            if (args.length == 1) {
                filename = args[0];
            }
            GNUAutomakefile makefile = new GNUAutomakefile();
            makefile.parse(filename);
            IDirective[] directive = makefile.getDirectives();
            int i = 0;
            while (i < directive.length) {
                System.out.print(directive[i]);
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public IBuiltinFunction[] getBuiltinFunctions() {
        return new IBuiltinFunction[0];
    }

    public IAutomaticVariable[] getAutomaticVariables() {
        return new IAutomaticVariable[0];
    }
}

