/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.MakeContentProvider;
import org.eclipse.cdt.make.ui.TargetSourceContainer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FilterEmtpyFoldersAction
extends Action {
    private static final String FILTER_EMPTY_FOLDERS = "FilterEmptyFolders";
    private TreeViewer fViewer;

    public FilterEmtpyFoldersAction(TreeViewer viewer) {
        super(MakeUIPlugin.getResourceString("FilterEmptyFolderAction.label"), 2);
        this.fViewer = viewer;
        this.setToolTipText(MakeUIPlugin.getResourceString("FilterEmptyFolderAction.tooltip"));
        this.setChecked(this.getSettings().getBoolean(FILTER_EMPTY_FOLDERS));
        this.setDisabledImageDescriptor(MakeUIImages.getImageDescriptor("icons/dtool16/target_filter.gif"));
        this.setImageDescriptor(MakeUIImages.getImageDescriptor("icons/etool16/target_filter.gif"));
        this.fViewer.addFilter(new ViewerFilter(){

            private boolean hasMakeTargets(final IContainer parentContainer) {
                final boolean[] haveTargets = new boolean[]{false};
                IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) {
                        if (haveTargets[0]) {
                            return false;
                        }
                        int rcType = proxy.getType();
                        if (rcType != 4 && rcType != 2) {
                            return false;
                        }
                        IContainer subFolder = (IContainer)proxy.requestResource();
                        if (!(parentContainer instanceof IProject) && !subFolder.equals((Object)parentContainer) && CCorePlugin.showSourceRootsAtTopOfProject() && MakeContentProvider.isSourceEntry((IResource)subFolder)) {
                            return false;
                        }
                        try {
                            IMakeTarget[] targets = MakeCorePlugin.getDefault().getTargetManager().getTargets(subFolder);
                            if (targets != null && targets.length > 0) {
                                haveTargets[0] = true;
                                return false;
                            }
                        }
                        catch (Exception e) {
                            MakeUIPlugin.log(e);
                        }
                        return true;
                    }
                };
                try {
                    parentContainer.accept(visitor, 0);
                }
                catch (Exception e) {
                    MakeUIPlugin.log(e);
                }
                return haveTargets[0];
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (FilterEmtpyFoldersAction.this.isChecked()) {
                    IContainer container = null;
                    if (element instanceof IContainer) {
                        container = (IContainer)element;
                        if (parentElement instanceof IProject && !(container instanceof IProject) && CCorePlugin.showSourceRootsAtTopOfProject() && MakeContentProvider.isSourceEntry((IResource)container)) {
                            return false;
                        }
                    } else if (element instanceof TargetSourceContainer) {
                        container = ((TargetSourceContainer)element).getContainer();
                    }
                    if (container != null) {
                        return this.hasMakeTargets(container);
                    }
                }
                return true;
            }
        });
    }

    public void run() {
        this.fViewer.refresh();
        this.getSettings().put(FILTER_EMPTY_FOLDERS, this.isChecked());
    }

    private IDialogSettings getSettings() {
        String sectionName = "org.eclipse.cdt.internal.ui.MakeView";
        IDialogSettings settings = MakeUIPlugin.getDefault().getDialogSettings().getSection("org.eclipse.cdt.internal.ui.MakeView");
        if (settings == null) {
            settings = MakeUIPlugin.getDefault().getDialogSettings().addNewSection("org.eclipse.cdt.internal.ui.MakeView");
        }
        return settings;
    }
}

