/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.registry.ITMResource;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;

public abstract class TMResource
implements ITMResource {
    private static final String PLATFORM_PLUGIN = "platform:/plugin/";
    private String path;
    private @Nullable String pluginId;

    protected TMResource() {
        this.path = "<set-by-gson>";
    }

    protected TMResource(IConfigurationElement ce) {
        this(ce.getAttribute("path"));
        this.pluginId = ce.getNamespaceIdentifier();
    }

    protected TMResource(String path) {
        this.path = path;
    }

    protected TMResource(String path, @Nullable String pluginId) {
        this.path = path;
        this.pluginId = pluginId;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public URI getURI() {
        return this.pluginId == null ? new File(this.path).toURI() : URI.create(PLATFORM_PLUGIN + this.pluginId + "/" + this.path);
    }

    @Override
    public @Nullable String getPluginId() {
        return this.pluginId;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(this.pluginId == null ? new FileInputStream(new File(this.path)) : new URL(PLATFORM_PLUGIN + this.pluginId + "/" + this.path).openStream());
    }

    @Override
    public long getLastModified() {
        try {
            return new File(this.pluginId == null ? this.path : FileLocator.resolve((URL)new URL(PLATFORM_PLUGIN + this.pluginId + "/" + this.path)).getFile()).lastModified();
        }
        catch (IOException ex) {
            return 0L;
        }
    }

    protected @Nullable String getResourceContent() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = this.getInputStream();){
                return new String(in.readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            TMEclipseRegistryPlugin.logError(ex);
            return null;
        }
    }
}

