/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.ls.core.internal.EventNotification;
import org.eclipse.jdt.ls.core.internal.EventType;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class SourceAttachUpdateHandler
implements IElementChangedListener {
    private final JavaClientConnection connection;

    public SourceAttachUpdateHandler(JavaClientConnection client) {
        this.connection = client;
    }

    public void elementChanged(ElementChangedEvent event) {
        HashSet<IJavaElement> sourceAttachChangedElements = new HashSet<IJavaElement>();
        this.processDelta(event.getDelta(), sourceAttachChangedElements);
        if (this.connection != null && !sourceAttachChangedElements.isEmpty()) {
            SourceInvalidatedEvent invalidatedJarSource = new SourceInvalidatedEvent();
            for (IJavaElement changedElement : sourceAttachChangedElements) {
                if (!(changedElement instanceof JarPackageFragmentRoot)) continue;
                JarPackageFragmentRoot jar = (JarPackageFragmentRoot)changedElement;
                try {
                    if (jar.getSourceAttachmentPath() == null) continue;
                    int downloadStatus = JavaLanguageServerPlugin.getDefaultSourceDownloader().getDownloadStatus((IPackageFragmentRoot)jar);
                    if (downloadStatus == 2) {
                        JavaLanguageServerPlugin.getDefaultSourceDownloader().clearDownloadStatus((IPackageFragmentRoot)jar);
                        continue;
                    }
                    if (downloadStatus == 4) {
                        invalidatedJarSource.addRootPath((IPackageFragmentRoot)jar, true);
                        JavaLanguageServerPlugin.getDefaultSourceDownloader().clearDownloadStatus((IPackageFragmentRoot)jar);
                        continue;
                    }
                    if (downloadStatus != 1) continue;
                    invalidatedJarSource.addRootPath((IPackageFragmentRoot)jar, false);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            if (!invalidatedJarSource.isEmpty()) {
                EventNotification notification = new EventNotification().withType(EventType.SourceInvalidated).withData(invalidatedJarSource);
                this.connection.sendEventNotification(notification);
            }
        }
    }

    public void addElementChangeListener() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void removeElementChangeListener() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    private void processDelta(IJavaElementDelta delta, Set<IJavaElement> result) {
        IJavaElement element = delta.getElement();
        if (element.getElementType() != 1 && !this.isClasspathChangedEvent(delta)) {
            return;
        }
        IJavaElementDelta[] children = delta.getAffectedChildren();
        if (children == null || children.length == 0) {
            if ((delta.getFlags() & 0x1000) != 0) {
                result.add(delta.getElement());
            }
            return;
        }
        IJavaElementDelta[] iJavaElementDeltaArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.processDelta(child, result);
            ++n2;
        }
    }

    private boolean isClasspathChangedEvent(IJavaElementDelta delta) {
        return (delta.getFlags() & 0x221000) != 0;
    }

    public static class SourceInvalidatedEvent {
        private Map<String, Boolean> affectedRootPaths = new LinkedHashMap<String, Boolean>();

        public void addRootPath(IPackageFragmentRoot root, boolean isAutoDownloadedSource) {
            this.affectedRootPaths.put(root.getPath().toPortableString(), isAutoDownloadedSource);
        }

        public boolean isEmpty() {
            return this.affectedRootPaths.isEmpty();
        }

        public boolean contains(IPackageFragmentRoot root, boolean isAutoDownloadedSource) {
            return this.affectedRootPaths.getOrDefault(root.getPath().toPortableString(), !isAutoDownloadedSource) == isAutoDownloadedSource;
        }
    }
}

