"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToggleStickyScroll = void 0;
const nls_1 = require("../../../../nls");
const actions_1 = require("../../../../platform/actions/common/actions");
const configuration_1 = require("../../../../platform/configuration/common/configuration");
const contextkey_1 = require("../../../../platform/contextkey/common/contextkey");
class ToggleStickyScroll extends actions_1.Action2 {
    constructor() {
        super({
            id: 'editor.action.toggleStickyScroll',
            title: {
                value: (0, nls_1.localize)('toggleStickyScroll', "Toggle Sticky Scroll"),
                mnemonicTitle: (0, nls_1.localize)('miStickyScroll', "&&Sticky Scroll"),
                original: 'Toggle Sticky Scroll',
            },
            // Hardcoding due to import violation
            category: { value: (0, nls_1.localize)('view', "View"), original: 'View' },
            toggled: contextkey_1.ContextKeyExpr.equals('config.editor.stickyScroll.enabled', true),
            menu: [
                { id: actions_1.MenuId.CommandPalette },
                { id: actions_1.MenuId.MenubarViewMenu, group: '5_editor', order: 6 },
            ]
        });
    }
    run(accessor) {
        return __awaiter(this, void 0, void 0, function* () {
            const configurationService = accessor.get(configuration_1.IConfigurationService);
            const newValue = !configurationService.getValue('editor.stickyScroll.enabled');
            return configurationService.updateValue('editor.stickyScroll.enabled', newValue);
        });
    }
}
exports.ToggleStickyScroll = ToggleStickyScroll;
//# sourceMappingURL=stickyScrollActions.js.map