"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var temp = require("temp");
var fs = require("fs-extra");
var Path = require("path");
var chai_1 = require("chai");
var commit_1 = require("./commit");
var test_helper_1 = require("./test-helper");
var git_1 = require("../core/git");
var branch_1 = require("./branch");
var track = temp.track();
var path;
var createAndCommit = function (filename, message) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                fs.createFileSync(Path.join(path, filename));
                return [4 /*yield*/, (0, git_1.git)(['add', '.'], path, 'add')];
            case 1:
                _a.sent();
                return [4 /*yield*/, (0, commit_1.createCommit)(path, message)];
            case 2:
                _a.sent();
                return [2 /*return*/];
        }
    });
}); };
var getCommitIds = function (repoPath) { return __awaiter(void 0, void 0, void 0, function () {
    var log, e_1;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                _a.trys.push([0, 2, , 3]);
                return [4 /*yield*/, (0, git_1.git)(['log', '--pretty=%H'], repoPath, 'log')];
            case 1:
                log = _a.sent();
                return [2 /*return*/, log.stdout.trim().split('\n')];
            case 2:
                e_1 = _a.sent();
                if (e_1.name === 'GitError' && e_1.result && e_1.result.exitCode && e_1.result.exitCode === 128) {
                    // git log on repo with no commits throws an error
                    return [2 /*return*/, []];
                }
                else {
                    throw e_1;
                }
                return [3 /*break*/, 3];
            case 3: return [2 /*return*/];
        }
    });
}); };
describe('branch', function () { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        beforeEach(function () { return __awaiter(void 0, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        path = track.mkdirSync('branch');
                        return [4 /*yield*/, (0, test_helper_1.initRepository)(path)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        }); });
        afterEach(function (done) {
            track.cleanup(done);
        });
        it('no branch before first commit', function () { return __awaiter(void 0, void 0, void 0, function () {
            var localBranches, currentBranch;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, (0, branch_1.listBranch)(path, 'all')];
                    case 1:
                        localBranches = _a.sent();
                        (0, chai_1.expect)(localBranches.length).to.be.equal(0);
                        return [4 /*yield*/, (0, branch_1.listBranch)(path, 'current')];
                    case 2:
                        currentBranch = _a.sent();
                        (0, chai_1.expect)(currentBranch).to.be.undefined;
                        return [2 /*return*/];
                }
            });
        }); });
        it('only master branch after first commit', function () { return __awaiter(void 0, void 0, void 0, function () {
            var localBranches, curretnBranch;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, createAndCommit('some-file.txt', 'first commit')];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, (0, branch_1.listBranch)(path, 'all')];
                    case 2:
                        localBranches = _a.sent();
                        (0, chai_1.expect)(localBranches.length).to.be.equal(1);
                        (0, chai_1.expect)(localBranches[0].name).to.be.equal('master');
                        return [4 /*yield*/, (0, branch_1.listBranch)(path, 'current')];
                    case 3:
                        curretnBranch = _a.sent();
                        (0, chai_1.expect)(curretnBranch).to.not.be.undefined;
                        (0, chai_1.expect)(curretnBranch.name).to.be.equal('master');
                        return [2 /*return*/];
                }
            });
        }); });
        it('new branch is selected on creation if checkout is true', function () { return __awaiter(void 0, void 0, void 0, function () {
            var newBranch, localBranches, currentBranch;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, createAndCommit('some-file.txt', 'first commit')];
                    case 1:
                        _a.sent();
                        newBranch = 'branch1';
                        return [4 /*yield*/, (0, branch_1.createBranch)(path, newBranch, { checkout: true })];
                    case 2:
                        _a.sent();
                        return [4 /*yield*/, (0, branch_1.listBranch)(path, 'all')];
                    case 3:
                        localBranches = _a.sent();
                        (0, chai_1.expect)(localBranches.length).to.be.equal(2);
                        (0, chai_1.expect)(localBranches[1].name).to.be.equal('master');
                        (0, chai_1.expect)(localBranches[0].name).to.be.equal(newBranch);
                        return [4 /*yield*/, (0, branch_1.listBranch)(path, 'current')];
                    case 4:
                        currentBranch = _a.sent();
                        (0, chai_1.expect)(currentBranch).to.not.be.undefined;
                        (0, chai_1.expect)(currentBranch.name).to.be.equal(newBranch);
                        return [2 /*return*/];
                }
            });
        }); });
        it('new branch is not selected on creation if checkout is false', function () { return __awaiter(void 0, void 0, void 0, function () {
            var newBranch, localBranches, currentBranch;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, createAndCommit('some-file.txt', 'first commit')];
                    case 1:
                        _a.sent();
                        newBranch = 'branch1';
                        return [4 /*yield*/, (0, branch_1.createBranch)(path, newBranch)];
                    case 2:
                        _a.sent();
                        return [4 /*yield*/, (0, branch_1.listBranch)(path, 'all')];
                    case 3:
                        localBranches = _a.sent();
                        (0, chai_1.expect)(localBranches.length).to.be.equal(2);
                        (0, chai_1.expect)(localBranches[1].name).to.be.equal('master');
                        (0, chai_1.expect)(localBranches[0].name).to.be.equal(newBranch);
                        return [4 /*yield*/, (0, branch_1.listBranch)(path, 'current')];
                    case 4:
                        currentBranch = _a.sent();
                        (0, chai_1.expect)(currentBranch).to.not.be.undefined;
                        (0, chai_1.expect)(currentBranch.name).to.be.equal('master');
                        return [2 /*return*/];
                }
            });
        }); });
        it('new branch is not created until first commit', function () { return __awaiter(void 0, void 0, void 0, function () {
            var newBranch, localBranches;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        newBranch = 'branch1';
                        return [4 /*yield*/, (0, branch_1.createBranch)(path, newBranch, { checkout: true })];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, (0, branch_1.listBranch)(path, 'all')];
                    case 2:
                        localBranches = _a.sent();
                        (0, chai_1.expect)(localBranches.length).to.be.equal(0);
                        return [2 /*return*/];
                }
            });
        }); });
        it('new branch is created on first commit in place of master if checkout is true', function () { return __awaiter(void 0, void 0, void 0, function () {
            var newBranch, localBranches, currentBranch;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        newBranch = 'branch1';
                        return [4 /*yield*/, (0, branch_1.createBranch)(path, newBranch, { checkout: true })];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, createAndCommit('some-file.txt', 'first commit')];
                    case 2:
                        _a.sent();
                        return [4 /*yield*/, (0, branch_1.listBranch)(path, 'all')];
                    case 3:
                        localBranches = _a.sent();
                        (0, chai_1.expect)(localBranches.length).to.be.equal(1);
                        (0, chai_1.expect)(localBranches[0].name).to.be.equal(newBranch);
                        return [4 /*yield*/, (0, branch_1.listBranch)(path, 'current')];
                    case 4:
                        currentBranch = _a.sent();
                        (0, chai_1.expect)(currentBranch).to.not.be.undefined;
                        (0, chai_1.expect)(currentBranch.name).to.be.equal(newBranch);
                        return [2 /*return*/];
                }
            });
        }); });
        it('a new branch cannot be created before master if checkout is false', function () { return __awaiter(void 0, void 0, void 0, function () {
            var newBranch, e_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        newBranch = 'branch1';
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, (0, branch_1.createBranch)(path, newBranch)];
                    case 2:
                        _a.sent();
                        chai_1.expect.fail('An error should have been thrown by createBranch');
                        return [3 /*break*/, 4];
                    case 3:
                        e_2 = _a.sent();
                        if (e_2.name === 'GitError' && e_2.result && e_2.result.exitCode && e_2.result.exitCode === 128) {
                            // git branch on repo with no commits should throw an error
                        }
                        else {
                            chai_1.expect.fail('createBranch failed with an unexpected error');
                        }
                        return [3 /*break*/, 4];
                    case 4: return [2 /*return*/];
                }
            });
        }); });
        it('new branch is created on correct start point', function () { return __awaiter(void 0, void 0, void 0, function () {
            var commitIds, firstCommitId, newBranch, localBranches, currentBranch, newCommitIds;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, createAndCommit('some-file.txt', 'first commit')];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, getCommitIds(path)];
                    case 2:
                        commitIds = _a.sent();
                        firstCommitId = commitIds[0];
                        return [4 /*yield*/, createAndCommit('other-text.txt', 'second commit')];
                    case 3:
                        _a.sent();
                        newBranch = 'branch1';
                        return [4 /*yield*/, (0, branch_1.createBranch)(path, newBranch, { startPoint: firstCommitId, checkout: true })];
                    case 4:
                        _a.sent();
                        return [4 /*yield*/, (0, branch_1.listBranch)(path, 'all')];
                    case 5:
                        localBranches = _a.sent();
                        (0, chai_1.expect)(localBranches.length).to.be.equal(2);
                        return [4 /*yield*/, (0, branch_1.listBranch)(path, 'current')];
                    case 6:
                        currentBranch = _a.sent();
                        (0, chai_1.expect)(currentBranch).to.not.be.undefined;
                        (0, chai_1.expect)(currentBranch.name).to.be.equal(newBranch);
                        return [4 /*yield*/, getCommitIds(path)];
                    case 7:
                        newCommitIds = _a.sent();
                        (0, chai_1.expect)(newCommitIds[0]).to.be.equal(firstCommitId);
                        return [2 /*return*/];
                }
            });
        }); });
        return [2 /*return*/];
    });
}); });
//# sourceMappingURL=branch.spec.js.map