/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.HighlightedPositionCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;

public class SemanticHighlightingPresenterCore {
    protected IPositionUpdater fPositionUpdater = new HighlightingPositionUpdater(this.getPositionCategory());
    protected List<Position> fPositions = new ArrayList<Position>();
    protected Object fPositionLock = new Object();
    protected boolean fIsCanceled = false;

    public HighlightedPositionCore createHighlightedPositionCore(int offset, int length, Object highlighting) {
        return new HighlightedPositionCore(offset, length, highlighting, this.fPositionUpdater);
    }

    protected void addPositionForEvent(DocumentEvent event, String category, int offset, int length, Object highlighting) {
        HighlightedPositionCore highlightedPosition = new HighlightedPositionCore(offset, length, highlighting, new Object());
        try {
            event.fDocument.addPosition(category, (Position)highlightedPosition);
        }
        catch (BadLocationException | BadPositionCategoryException e) {
            Platform.getLog(this.getClass()).error("Error when adding new highlighting position to the document", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllPositions(List<Position> list) {
        Object object = this.fPositionLock;
        synchronized (object) {
            list.addAll(this.fPositions);
        }
    }

    public Runnable createUpdateRunnableCore(IDocument document, List<Position> addedPositions, List<Position> removedPositions) {
        HighlightedPositionCore[] added = new HighlightedPositionCore[addedPositions.size()];
        addedPositions.toArray(added);
        HighlightedPositionCore[] removed = new HighlightedPositionCore[removedPositions.size()];
        removedPositions.toArray(removed);
        if (this.isCanceled()) {
            return null;
        }
        Runnable runnable = () -> this.updatePresentationCore(document, added, removed);
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updatePresentationCore(IDocument document, HighlightedPositionCore[] addedPositions, HighlightedPositionCore[] removedPositions) {
        if (this.isCanceled()) {
            return;
        }
        if (document == null) {
            return;
        }
        String positionCategory = this.getPositionCategory();
        List<HighlightedPositionCore> removedPositionsList = Arrays.asList(removedPositions);
        try {
            Object object = this.fPositionLock;
            synchronized (object) {
                List<Position> oldPositions = this.fPositions;
                int newSize = Math.max(this.fPositions.size() + addedPositions.length - removedPositions.length, 10);
                ArrayList<Position> newPositions = new ArrayList<Position>(newSize);
                Position position = null;
                HighlightedPositionCore addedPosition = null;
                int i = 0;
                int j = 0;
                int n = oldPositions.size();
                int m = addedPositions.length;
                block5: while (true) {
                    block13: {
                        block14: {
                            if (i >= n && position == null && j >= m && addedPosition == null) {
                                this.fPositions = newPositions;
                                return;
                            }
                            while (true) {
                                if (position != null || i >= n) {
                                    if (addedPosition == null && j < m) {
                                        addedPosition = addedPositions[j++];
                                        document.addPosition(positionCategory, (Position)addedPosition);
                                    }
                                    if (position == null) break block13;
                                    if (addedPosition != null) {
                                        if (position.getOffset() > addedPosition.getOffset()) break;
                                        newPositions.add(position);
                                        position = null;
                                        continue block5;
                                    }
                                    break block14;
                                }
                                if (!(position = oldPositions.get(i++)).isDeleted() && !this.contain(removedPositionsList, position)) continue;
                                document.removePosition(positionCategory, position);
                                position = null;
                            }
                            newPositions.add(addedPosition);
                            addedPosition = null;
                            continue;
                        }
                        newPositions.add(position);
                        position = null;
                        continue;
                    }
                    if (addedPosition == null) continue;
                    newPositions.add(addedPosition);
                    addedPosition = null;
                }
            }
        }
        catch (BadLocationException | BadPositionCategoryException e) {
            JavaManipulationPlugin.log(e);
        }
    }

    protected boolean contain(List<? extends Position> positions, Position position) {
        return this.indexOf(positions, position) != -1;
    }

    protected int indexOf(List<? extends Position> positions, Position position) {
        int index = this.computeIndexAtOffset(positions, position.getOffset());
        int size = positions.size();
        while (index < size) {
            if (positions.get(index) == position) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected int computeIndexAtOffset(List<? extends Position> positions, int offset) {
        int i = -1;
        int j = positions.size();
        while (j - i > 1) {
            int k = i + j >> 1;
            Position position = positions.get(k);
            if (position.getOffset() >= offset) {
                j = k;
                continue;
            }
            i = k;
        }
        return j;
    }

    public boolean isCanceled() {
        return this.fIsCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.fIsCanceled = isCanceled;
    }

    public String getPositionCategory() {
        return this.toString();
    }

    protected class HighlightingPositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public HighlightingPositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventEnd = eventOffset + eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    HighlightedPositionCore position = (HighlightedPositionCore)positions[i];
                    int offset = position.getOffset();
                    int length = position.getLength();
                    int end = offset + length;
                    if (offset > eventEnd) {
                        this.updateWithPrecedingEvent(position, event);
                    } else if (end < eventOffset) {
                        this.updateWithSucceedingEvent(position, event);
                    } else if (offset <= eventOffset && end >= eventEnd) {
                        this.updateWithIncludedEvent(position, event);
                    } else if (offset <= eventOffset) {
                        this.updateWithOverEndEvent(position, event);
                    } else if (end >= eventEnd) {
                        this.updateWithOverStartEvent(position, event);
                    } else {
                        this.updateWithIncludingEvent(position, event);
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        private void updateWithPrecedingEvent(HighlightedPositionCore position, DocumentEvent event) {
            String newText = event.getText();
            int eventNewLength = newText != null ? newText.length() : 0;
            int deltaLength = eventNewLength - event.getLength();
            position.setOffset(position.getOffset() + deltaLength);
        }

        private void updateWithSucceedingEvent(HighlightedPositionCore position, DocumentEvent event) {
        }

        private void updateWithIncludedEvent(HighlightedPositionCore position, DocumentEvent event) {
            int eventOffset = event.getOffset();
            String newText = event.getText();
            if (newText == null) {
                newText = "";
            }
            int eventNewLength = newText.length();
            int deltaLength = eventNewLength - event.getLength();
            int offset = position.getOffset();
            int length = position.getLength();
            int end = offset + length;
            int includedLength = 0;
            while (includedLength < eventNewLength && Character.isJavaIdentifierPart(newText.charAt(includedLength))) {
                ++includedLength;
            }
            if (includedLength == eventNewLength) {
                position.setLength(length + deltaLength);
            } else {
                int newLeftLength = eventOffset - offset + includedLength;
                int excludedLength = eventNewLength;
                while (excludedLength > 0 && Character.isJavaIdentifierPart(newText.charAt(excludedLength - 1))) {
                    --excludedLength;
                }
                int newRightOffset = eventOffset + excludedLength;
                int newRightLength = end + deltaLength - newRightOffset;
                if (newRightLength == 0) {
                    position.setLength(newLeftLength);
                } else if (newLeftLength == 0) {
                    position.update(newRightOffset, newRightLength);
                } else {
                    position.setLength(newLeftLength);
                    SemanticHighlightingPresenterCore.this.addPositionForEvent(event, this.fCategory, newRightOffset, newRightLength, position.getHighlighting());
                }
            }
        }

        private void updateWithOverEndEvent(HighlightedPositionCore position, DocumentEvent event) {
            String newText = event.getText();
            if (newText == null) {
                newText = "";
            }
            int eventNewLength = newText.length();
            int includedLength = 0;
            while (includedLength < eventNewLength && Character.isJavaIdentifierPart(newText.charAt(includedLength))) {
                ++includedLength;
            }
            position.setLength(event.getOffset() - position.getOffset() + includedLength);
        }

        private void updateWithOverStartEvent(HighlightedPositionCore position, DocumentEvent event) {
            int eventNewLength;
            int eventOffset = event.getOffset();
            int eventEnd = eventOffset + event.getLength();
            String newText = event.getText();
            if (newText == null) {
                newText = "";
            }
            int excludedLength = eventNewLength = newText.length();
            while (excludedLength > 0 && Character.isJavaIdentifierPart(newText.charAt(excludedLength - 1))) {
                --excludedLength;
            }
            int deleted = eventEnd - position.getOffset();
            int inserted = eventNewLength - excludedLength;
            position.update(eventOffset + excludedLength, position.getLength() - deleted + inserted);
        }

        private void updateWithIncludingEvent(HighlightedPositionCore position, DocumentEvent event) {
            position.delete();
            position.update(event.getOffset(), 0);
        }
    }
}

