/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.WorkspaceFolder;

public class WorkspaceFolderChangeHandler {
    private ProjectsManager projectManager;
    private PreferenceManager preferenceManager;

    public WorkspaceFolderChangeHandler(ProjectsManager projectManager, PreferenceManager preferenceManager) {
        this.projectManager = projectManager;
        this.preferenceManager = preferenceManager;
    }

    public void update(DidChangeWorkspaceFoldersParams params) {
        IPath rootPath;
        ArrayList<IPath> addedRootPaths = new ArrayList<IPath>();
        ArrayList<IPath> removedRootPaths = new ArrayList<IPath>();
        for (WorkspaceFolder folder : params.getEvent().getAdded()) {
            rootPath = ResourceUtils.canonicalFilePathFromURI(folder.getUri());
            if (rootPath == null) continue;
            addedRootPaths.add(rootPath);
        }
        for (WorkspaceFolder folder : params.getEvent().getRemoved()) {
            rootPath = ResourceUtils.canonicalFilePathFromURI(folder.getUri());
            if (rootPath == null) continue;
            removedRootPaths.add(rootPath);
        }
        this.updateRootPaths(addedRootPaths, removedRootPaths);
        this.projectManager.updateWorkspaceFolders(addedRootPaths, removedRootPaths);
    }

    private void updateRootPaths(Collection<IPath> addedRootPaths, Collection<IPath> removedRootPaths) {
        HashSet<IPath> rootPathSet = new HashSet<IPath>(this.preferenceManager.getPreferences().getRootPaths());
        rootPathSet.removeAll(removedRootPaths);
        rootPathSet.addAll(addedRootPaths);
        this.preferenceManager.getPreferences().setRootPaths(rootPathSet);
    }
}

