/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.semantictokens.SemanticTokens;
import org.eclipse.jdt.ls.core.internal.semantictokens.SemanticTokensVisitor;

public class SemanticTokensCommand {
    public static SemanticTokens provide(String uri) {
        JobHelpers.waitForJobs("DocumentLifeCycleJobs", null);
        return SemanticTokensCommand.doProvide(uri);
    }

    private static SemanticTokens doProvide(String uri) {
        ITypeRoot typeRoot = JDTUtils.resolveTypeRoot(uri);
        if (typeRoot == null) {
            return new SemanticTokens(new int[0]);
        }
        CompilationUnit root = CoreASTProvider.getInstance().getAST(typeRoot, CoreASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
        if (root == null) {
            return new SemanticTokens(new int[0]);
        }
        SemanticTokensVisitor collector = new SemanticTokensVisitor(root);
        root.accept((ASTVisitor)collector);
        return collector.getSemanticTokens();
    }
}

