/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.SA;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jdk.test.lib.JDKToolLauncher;
import jdk.test.lib.Platform;
import jtreg.SkippedException;

public class SATestUtils {
    public static ProcessBuilder createProcessBuilder(JDKToolLauncher launcher) {
        List<String> cmdStringList = Arrays.asList(launcher.getCommand());
        if (SATestUtils.needsPrivileges()) {
            cmdStringList = SATestUtils.addPrivileges(cmdStringList);
        }
        return new ProcessBuilder(cmdStringList);
    }

    public static void skipIfCannotAttach() {
        if (!Platform.hasSA()) {
            throw new SkippedException("SA not supported.");
        }
        try {
            if (Platform.isLinux()) {
                if (!SATestUtils.canPtraceAttachLinux()) {
                    throw new SkippedException("SA Attach not expected to work. Ptrace attach not supported.");
                }
            } else if (Platform.isOSX()) {
                if (Platform.isHardenedOSX()) {
                    throw new SkippedException("SA Attach not expected to work. JDK is hardened.");
                }
                if (SATestUtils.needsPrivileges() && !SATestUtils.canAddPrivileges()) {
                    throw new SkippedException("SA Attach not expected to work. Insufficient privileges (developer mode disabled, not root, and can't use sudo).");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("skipIfCannotAttach() failed due to IOException.", e);
        }
    }

    public static boolean needsPrivileges() {
        if (!Platform.isOSX()) {
            return false;
        }
        if (Platform.isRoot()) {
            return false;
        }
        return !SATestUtils.developerModeEnabled();
    }

    private static boolean developerModeEnabled() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("DevToolsSecurity");
        cmd.add("--status");
        ProcessBuilder pb = new ProcessBuilder(cmd);
        try {
            Process p = pb.start();
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("DevToolsSecurity process interrupted", e);
            }
            String out = new String(p.getInputStream().readAllBytes());
            String err = new String(p.getErrorStream().readAllBytes());
            System.out.print("DevToolsSecurity stdout: " + out);
            if (out.equals("")) {
                System.out.println();
            }
            System.out.print("DevToolsSecurity stderr: " + err);
            if (err.equals("")) {
                System.out.println();
            }
            if (out.contains("Developer mode is currently enabled")) {
                return true;
            }
            if (out.contains("Developer mode is currently disabled")) {
                return false;
            }
            throw new RuntimeException("DevToolsSecurity failed to generate expected output: " + out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean canAddPrivileges() throws IOException {
        ArrayList<String> sudoList = new ArrayList<String>();
        sudoList.add("sudo");
        sudoList.add("-E");
        sudoList.add("-n");
        sudoList.add("/bin/echo");
        sudoList.add("'Checking for sudo'");
        ProcessBuilder pb = new ProcessBuilder(sudoList);
        Process echoProcess = pb.start();
        try {
            if (!echoProcess.waitFor(60L, TimeUnit.SECONDS)) {
                echoProcess.destroyForcibly();
                throw new RuntimeException("Timed out waiting for sudo to execute.");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("sudo process interrupted", e);
        }
        if (echoProcess.exitValue() == 0) {
            return true;
        }
        InputStream is = echoProcess.getErrorStream();
        String err = new String(is.readAllBytes());
        System.out.println(err);
        if (err.contains("no tty present") || err.contains("a password is required")) {
            return false;
        }
        throw new RuntimeException("Unknown error from 'sudo': " + err);
    }

    private static List<String> addPrivileges(List<String> cmdStringList) {
        if (!Platform.isOSX()) {
            throw new RuntimeException("Can only add privileges on OSX.");
        }
        System.out.println("Adding 'sudo -E -n' to the command.");
        ArrayList<String> outStringList = new ArrayList<String>();
        outStringList.add("sudo");
        outStringList.add("-E");
        outStringList.add("-n");
        outStringList.addAll(cmdStringList);
        return outStringList;
    }

    public static void addPrivilegesIfNeeded(ProcessBuilder pb) {
        if (!Platform.isOSX()) {
            return;
        }
        if (SATestUtils.needsPrivileges()) {
            List<String> cmdStringList = pb.command();
            cmdStringList = SATestUtils.addPrivileges(cmdStringList);
            pb.command(cmdStringList);
        }
    }

    private static boolean canPtraceAttachLinux() throws IOException {
        Path ptrace_scope;
        Path deny_ptrace = Paths.get("/sys/fs/selinux/booleans/deny_ptrace", new String[0]);
        if (Files.exists(deny_ptrace, new LinkOption[0])) {
            try {
                byte[] bb = AccessController.doPrivileged(() -> Files.readAllBytes(deny_ptrace));
                if (bb.length == 0) {
                    throw new Error("deny_ptrace is empty");
                }
                if (bb[0] != 48) {
                    return false;
                }
            }
            catch (PrivilegedActionException e) {
                IOException t = (IOException)e.getException();
                throw t;
            }
        }
        if (Files.exists(ptrace_scope = Paths.get("/proc/sys/kernel/yama/ptrace_scope", new String[0]), new LinkOption[0])) {
            try {
                byte[] bb = AccessController.doPrivileged(() -> Files.readAllBytes(ptrace_scope));
                if (bb.length == 0) {
                    throw new Error("ptrace_scope is empty");
                }
                byte yama_scope = bb[0];
                if (yama_scope == 51) {
                    return false;
                }
                if (!Platform.isRoot() && yama_scope != 48) {
                    return false;
                }
            }
            catch (PrivilegedActionException e) {
                IOException t = (IOException)e.getException();
                throw t;
            }
        }
        return true;
    }

    public static void validateSADebugDPrivileges() {
        if (Platform.isOSX() && !Platform.isRoot()) {
            throw new SkippedException("Cannot run this test on OSX if adding privileges is required.");
        }
    }
}

