/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.metrics;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.rest.metrics.SoftwareReqVolatilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeIgnoreType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;

public final class SoftwareReqVolatilityMetrics
implements StreamingOutput {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    private String programVersion;
    private final String targetVersion;
    private final Date startDate;
    private final Date endDate;
    private final boolean allTime;
    Collection<IAtsTask> tasksMissingChangeType = new ArrayList<IAtsTask>();
    Map<IAtsTeamWorkflow, List<ChangeItem>> wfToJsonMap = new HashMap<IAtsTeamWorkflow, List<ChangeItem>>();
    private ExcelXmlWriter writer;
    Pattern UI_NAME = Pattern.compile("\\{.*\\}");
    private final SoftwareReqVolatilityId[] reportColumns = new SoftwareReqVolatilityId[]{SoftwareReqVolatilityId.ACT, SoftwareReqVolatilityId.TW, SoftwareReqVolatilityId.ActionName, SoftwareReqVolatilityId.Program, SoftwareReqVolatilityId.Build, SoftwareReqVolatilityId.Date, SoftwareReqVolatilityId.Completed, SoftwareReqVolatilityId.AddedReq, SoftwareReqVolatilityId.ModifiedReq, SoftwareReqVolatilityId.DeletedReq, SoftwareReqVolatilityId.AddedSub, SoftwareReqVolatilityId.ModifiedSub, SoftwareReqVolatilityId.DeletedSub, SoftwareReqVolatilityId.AddedHeading, SoftwareReqVolatilityId.ModifiedHeading, SoftwareReqVolatilityId.DeletedHeading};

    public SoftwareReqVolatilityMetrics(OrcsApi orcsApi, AtsApi atsApi, String targetVersion, Date startDate, Date endDate, boolean allTime) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.programVersion = null;
        this.targetVersion = targetVersion;
        this.startDate = startDate;
        this.endDate = endDate;
        this.allTime = allTime;
    }

    public void write(OutputStream output) {
        try {
            this.writer = new ExcelXmlWriter((Writer)new OutputStreamWriter(output, "UTF-8"));
            this.writeReport();
            this.writer.endWorkbook();
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void writeReport() throws IOException {
        Collection<IAtsTeamWorkflow> reqWorkflows = this.getDatedWorkflows();
        if (!reqWorkflows.isEmpty()) {
            this.writer.startSheet("SRV", this.reportColumns.length);
            this.fillActionableData(reqWorkflows);
        }
    }

    private Collection<IAtsTeamWorkflow> getDatedWorkflows() {
        ArtifactToken versionId = this.atsApi.getQueryService().getArtifactFromTypeAndAttribute(AtsArtifactTypes.Version, (AttributeTypeToken)CoreAttributeTypes.Name, this.targetVersion, (BranchId)this.atsApi.getAtsBranch());
        Version version = this.atsApi.getVersionService().getVersionById((ArtifactId)versionId);
        Collection workflowArts = this.atsApi.getVersionService().getTargetedForTeamWorkflows((IAtsVersion)version);
        ArrayList<IAtsTeamWorkflow> reqWorkflows = new ArrayList<IAtsTeamWorkflow>();
        for (IAtsTeamWorkflow workflow : workflowArts) {
            try {
                boolean isReqWf = false;
                isReqWf = workflow.isWorkType(WorkType.Requirements);
                WorkDefinition workDef = workflow.getWorkDefinition();
                if (!isReqWf && workDef != null) {
                    isReqWf = workDef.getName().contains("Requirements");
                }
                if (!isReqWf || !workflow.isCompleted() || !this.allTime && (!workflow.getCompletedDate().after(this.startDate) || !workflow.getCompletedDate().before(this.endDate))) continue;
                reqWorkflows.add(workflow);
            }
            catch (Exception exception) {}
        }
        this.programVersion = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition).getName();
        for (IAtsTeamWorkflow teamWf : reqWorkflows) {
            BranchToken branch = this.atsApi.getBranchService().getBranch(teamWf);
            if (branch == null || branch.isInvalid()) continue;
            String changeReportData = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)CoreAttributeTypes.BranchDiffData, (Object)"");
            List changeItems = new ArrayList();
            if (!changeReportData.isEmpty()) {
                changeItems = JsonUtil.readValues((String)changeReportData, ChangeItem.class);
            } else {
                try {
                    changeItems = this.orcsApi.getBranchOps().compareBranch((BranchId)branch);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            this.wfToJsonMap.put(teamWf, changeItems);
        }
        return reqWorkflows;
    }

    private void fillActionableData(Collection<IAtsTeamWorkflow> reqWorkflows) throws IOException {
        int numColumns = this.reportColumns.length;
        Object[] buffer = new Object[numColumns];
        int i = 0;
        while (i < numColumns) {
            buffer[i] = this.reportColumns[i].getDisplayName();
            ++i;
        }
        this.writer.writeRow(buffer);
        for (Map.Entry<IAtsTeamWorkflow, List<ChangeItem>> entry : this.wfToJsonMap.entrySet()) {
            IAtsTeamWorkflow reqWorkflow = entry.getKey();
            List<ChangeItem> changeItems = entry.getValue();
            Date completedDate = new Date();
            try {
                completedDate = reqWorkflow.getCompletedDate();
                buffer[6] = !completedDate.equals(new Date(0L)) ? completedDate : "";
            }
            catch (Exception exception) {
                buffer[6] = "Missing or Multiple Values";
            }
            try {
                buffer[0] = reqWorkflow.getParentAction().getAtsId();
            }
            catch (Exception exception) {
                buffer[0] = "";
            }
            try {
                buffer[1] = reqWorkflow.getAtsId();
            }
            catch (Exception exception) {
                buffer[1] = "";
            }
            try {
                buffer[2] = reqWorkflow.getName();
            }
            catch (Exception exception) {
                buffer[2] = "";
            }
            buffer[3] = this.programVersion;
            buffer[4] = this.targetVersion;
            Date createdDate = new Date();
            try {
                createdDate = reqWorkflow.getCreatedDate();
                buffer[5] = !createdDate.equals(new Date(0L)) ? createdDate : "";
            }
            catch (Exception exception) {
                buffer[5] = "Missing or Multiple Values";
            }
            ArrayList<ChangeItem> attrChangeItems = new ArrayList<ChangeItem>();
            HashMap<ArtifactId, ChangeItem> artChangeItems = new HashMap<ArtifactId, ChangeItem>();
            for (ChangeItem changeItem : changeItems) {
                if (changeItem.getChangeType().equals((Object)ChangeType.Attribute) && changeItem.getIgnoreType().equals((Object)ChangeIgnoreType.NONE) && changeItem.getItemTypeId().equals(CoreAttributeTypes.WordTemplateContent)) {
                    attrChangeItems.add(changeItem);
                    continue;
                }
                if (!changeItem.getChangeType().equals((Object)ChangeType.Artifact)) continue;
                artChangeItems.put(changeItem.getArtId(), changeItem);
            }
            int swAdded = 0;
            int swModified = 0;
            int swDeleted = 0;
            int subAdded = 0;
            int subModified = 0;
            int subDeleted = 0;
            int headAdded = 0;
            int headModified = 0;
            int headDeleted = 0;
            for (ChangeItem changeItem : attrChangeItems) {
                ModificationType modType;
                BranchToken workingBranch = this.atsApi.getBranchService().getBranch(reqWorkflow);
                BranchId parentBranch = this.atsApi.getBranchService().getParentBranch((BranchId)workingBranch);
                ArtifactTypeToken artType = ArtifactTypeToken.SENTINEL;
                artType = this.orcsApi.getQueryFactory().fromBranch(parentBranch).includeDeletedAttributes(true).includeDeletedArtifacts(true).andId(changeItem.getArtId()).asArtifactTokenOrSentinel().getArtifactType();
                if (artType.isInvalid() && (artType = this.orcsApi.tokenService().getArtifactTypeOrSentinel(((ChangeItem)artChangeItems.get(changeItem.getArtId())).getItemTypeId().getId())).isInvalid() && (artType = this.orcsApi.getQueryFactory().fromBranch((BranchId)workingBranch).includeDeletedAttributes(true).includeDeletedArtifacts(true).andId(changeItem.getArtId()).asArtifactTokenOrSentinel().getArtifactType()).isInvalid()) continue;
                if (artType.inheritsFrom((ArtifactTypeId)CoreArtifactTypes.AbstractSoftwareRequirement)) {
                    modType = changeItem.getNetChange().getModType();
                    if (modType.equals(ModificationType.NEW)) {
                        ++swAdded;
                        continue;
                    }
                    if (modType.equals(ModificationType.MODIFIED) || modType.equals(ModificationType.MERGED)) {
                        ++swModified;
                        continue;
                    }
                    if (!modType.equals(ModificationType.DELETED) && !modType.equals(ModificationType.ARTIFACT_DELETED)) continue;
                    ++swDeleted;
                    continue;
                }
                if (artType.inheritsFrom((ArtifactTypeId)CoreArtifactTypes.AbstractSubsystemRequirement)) {
                    modType = changeItem.getNetChange().getModType();
                    if (modType.equals(ModificationType.NEW)) {
                        ++subAdded;
                        continue;
                    }
                    if (modType.equals(ModificationType.MODIFIED) || modType.equals(ModificationType.MERGED)) {
                        ++subModified;
                        continue;
                    }
                    if (!modType.equals(ModificationType.DELETED) && !modType.equals(ModificationType.ARTIFACT_DELETED)) continue;
                    ++subDeleted;
                    continue;
                }
                if (!artType.inheritsFrom((ArtifactTypeId)CoreArtifactTypes.AbstractHeading)) continue;
                modType = changeItem.getNetChange().getModType();
                if (modType.equals(ModificationType.NEW)) {
                    ++headAdded;
                    continue;
                }
                if (modType.equals(ModificationType.MODIFIED) || modType.equals(ModificationType.MERGED)) {
                    ++headModified;
                    continue;
                }
                if (!modType.equals(ModificationType.DELETED) && !modType.equals(ModificationType.ARTIFACT_DELETED)) continue;
                ++headDeleted;
            }
            if (!attrChangeItems.isEmpty()) {
                buffer[7] = swAdded;
                buffer[8] = swModified;
                buffer[9] = swDeleted;
                buffer[10] = subAdded;
                buffer[11] = subModified;
                buffer[12] = subDeleted;
                buffer[13] = headAdded;
                buffer[14] = headModified;
                buffer[15] = headDeleted;
            } else {
                buffer[7] = "";
                buffer[8] = "";
                buffer[9] = "";
                buffer[10] = "";
                buffer[11] = "";
                buffer[12] = "";
                buffer[13] = "";
                buffer[14] = "";
                buffer[15] = "";
            }
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        this.writer.endSheet();
    }
}

