/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.metrics;

import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.rest.metrics.DevProgressMetrics;
import org.eclipse.osee.ats.rest.metrics.SoftwareReqVolatilityMetrics;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.orcs.OrcsApi;

public class MetricsReportOperations {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;

    public MetricsReportOperations(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public Response generateDevProgressReport(String targetVersion, Date startDate, Date endDate, boolean allTime) {
        DevProgressMetrics streamingOutput = new DevProgressMetrics(this.orcsApi, this.atsApi, targetVersion, startDate, endDate, allTime);
        String fileName = String.format("DevelopmentProgressMetrics_%s_%s.xml", targetVersion, Lib.getDateTimeString());
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput, (String)"application/octet-stream");
        builder.header("Content-Disposition", (Object)("attachment; filename=" + fileName)).header("FileName", (Object)fileName);
        return builder.build();
    }

    public Response generateSoftwareReqVolatility(String targetVersion, Date startDate, Date endDate, boolean allTime) {
        SoftwareReqVolatilityMetrics streamingOutput = new SoftwareReqVolatilityMetrics(this.orcsApi, this.atsApi, targetVersion, startDate, endDate, allTime);
        String fileName = String.format("SoftwareRequirementsVolatilityMetrics_%s_%s.xml", targetVersion, Lib.getDateTimeString());
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput, (String)"application/octet-stream");
        builder.header("Content-Disposition", (Object)("attachment; filename=" + fileName)).header("FileName", (Object)fileName);
        return builder.build();
    }

    public Response setBranchDiffData(String atsId) {
        try {
            IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItemByAtsId(atsId);
            if (!(workItem instanceof IAtsTeamWorkflow)) {
                return Response.status((int)406, (String)"Provided atsId is not a Team Workflow").build();
            }
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
            BranchToken branch = this.atsApi.getBranchService().getBranch(teamWf);
            if (!this.atsApi.getBranchService().branchExists((BranchId)branch)) {
                return Response.ok().build();
            }
            if (branch == null || branch.isInvalid()) {
                return Response.status((int)406, (String)"Branch Value is invalid").build();
            }
            List changeItems = this.orcsApi.getBranchOps().compareBranch((BranchId)branch);
            if (changeItems.isEmpty()) {
                return Response.ok().build();
            }
            String changeItemJson = JsonUtil.toJson((Object)changeItems);
            if (this.atsApi.getAttributeResolver().getAttributeCount((IAtsWorkItem)teamWf, (AttributeTypeToken)CoreAttributeTypes.BranchDiffData) == 0) {
                this.atsApi.getAttributeResolver().addAttribute(workItem, (AttributeTypeId)CoreAttributeTypes.BranchDiffData, (Object)changeItemJson);
            } else if (!((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)CoreAttributeTypes.BranchDiffData, (Object)"")).equals(changeItemJson)) {
                this.atsApi.getAttributeResolver().setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)CoreAttributeTypes.BranchDiffData, (Object)changeItemJson);
            }
        }
        catch (Exception ex) {
            OseeLog.log(MetricsReportOperations.class, (Level)Level.WARNING, (String)"Error setting Branch Diff Data JSON", (Throwable)ex);
        }
        return Response.ok().build();
    }
}

