/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;

public class RestUtil {
    public static String simplePageHtml(String title, String message) throws Exception {
        String html = OseeInf.getResourceContents((String)"templates/simple.html", RestUtil.class);
        html = html.replaceFirst("<\\?PUT_MESSAGE_HERE\\?>", message);
        html = html.replaceFirst("<\\?PUT_TITLE_HERE\\?>", title);
        return html;
    }

    public static String simplePageHtml(String message) throws Exception {
        return RestUtil.simplePageHtml("ATS", message);
    }

    public static Response simplePageResponse(String message) throws Exception {
        return RestUtil.simplePageResponse("ATS", message);
    }

    public static Response simplePageResponse(String title, String message) throws Exception {
        return Response.status((int)200).entity((Object)RestUtil.simplePageHtml(title, message)).build();
    }

    public static ViewModel simplePage(String message) {
        return RestUtil.simplePage("ATS", message);
    }

    public static ViewModel simplePage(String title, String message) {
        return new ViewModel("simple.html").param("PUT_MESSAGE_HERE", (Object)message).param("PUT_TITLE_HERE", (Object)title);
    }

    public static Response redirect(IAtsWorkItem workItem, String defaultUrl, AtsApi atsApi) {
        return RestUtil.redirect(Arrays.asList(workItem), defaultUrl, atsApi);
    }

    public static Response redirect(Collection<? extends IAtsWorkItem> workItems, String defaultUrl, AtsApi atsApi) {
        String actionUrl = AtsUtil.getBaseActionUiUrl((String)defaultUrl, (AtsApi)atsApi);
        String ids = "";
        for (IAtsWorkItem iAtsWorkItem : workItems) {
            ids = String.valueOf(ids) + iAtsWorkItem.getAtsId() + ",";
        }
        ids = ids.replaceFirst(",$", "");
        actionUrl = actionUrl.replaceFirst("ID", ids);
        URI uRI = UriBuilder.fromUri((String)actionUrl).build(new Object[0]);
        return Response.seeOther((URI)uRI).build();
    }

    public static Response returnBadRequest(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
    }

    public static Response returnInternalServerError(String message) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).build();
    }
}

