/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerUtils;

public class ServerHealthActiveMq {
    private final JdbcClient jdbcClient;

    public ServerHealthActiveMq(IApplicationServerManager appServerMgr, JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    public String getHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h3>Active MQ</h3>");
        String activeMqUrl = OseeInfo.getCachedValue((JdbcClient)this.jdbcClient, (String)"osee.activemq.url");
        if (Strings.isValid((String)activeMqUrl)) {
            try {
                String urlPageHtml = AHTML.getUrlPageHtml((String)activeMqUrl);
                boolean goodPage = urlPageHtml.contains("Apache ActiveMQ");
                String urlImage = "";
                String result = "";
                if (goodPage) {
                    urlImage = ServerUtils.getImage("greenDot.png", activeMqUrl);
                    result = "ActiveMQ - Active";
                } else {
                    urlImage = ServerUtils.getImage("redDot.png", activeMqUrl);
                    result = "ActiveMQ - Down";
                }
                return AHTML.simplePageWithImageUrl((String)String.format("<a href=\"%s\">Active MQ Event Service - Select for Dashboard</a>", activeMqUrl), (String)urlImage, (String)result);
            }
            catch (Exception ex) {
                return AHTML.simplePage((String)"Active MQ Event Service", (String)Lib.exceptionToString((Exception)ex));
            }
        }
        return AHTML.simplePage((String)"Active MQ Event Service", (String)"osee.activemq.url not in defined in OSEE_INFO");
    }
}

