/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;

@Swagger
public class AnnotationResource {
    private final DispoApi dispoApi;
    private final BranchId branch;
    private final String itemId;

    public AnnotationResource(DispoApi dispoApi, BranchId branch, String setUuid, String dispResourceId) {
        this.dispoApi = dispoApi;
        this.branch = branch;
        this.itemId = dispResourceId;
    }

    @POST
    @Consumes(value={"application/json"})
    @Operation(summary="Create a new Annotation given an AnnotationData object")
    @Tag(name="annotation")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Successfully created the Annotation"), @ApiResponse(responseCode="400", description="Bad Request. Did not provide a location range")})
    public Response postDispoAnnotation(DispoAnnotationData annotation, @Parameter(description="The Username") @QueryParam(value="userName") String userName) {
        Response response;
        if (!annotation.getLocationRefs().isEmpty()) {
            DispoAnnotationData createdAnnotation;
            Response.Status status;
            String createdAnnotationId = this.dispoApi.createDispoAnnotation(this.branch, this.itemId, annotation, userName, false);
            if (!createdAnnotationId.equals("")) {
                status = Response.Status.CREATED;
                createdAnnotation = this.dispoApi.getDispoAnnotationById(this.branch, this.itemId, createdAnnotationId);
            } else {
                status = Response.Status.NOT_ACCEPTABLE;
                createdAnnotation = null;
            }
            response = Response.status((Response.Status)status).entity(createdAnnotation).build();
        } else {
            Response.Status status = Response.Status.BAD_REQUEST;
            response = Response.status((Response.Status)status).entity((Object)"The Annotation must have a valid location reference").build();
        }
        return response;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get all Annotations for the DisposioableItem")
    @Tag(name="annotations")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Found Annotations"), @ApiResponse(responseCode="404", description="Not found. Could not find any Annotations")})
    public Iterable<DispoAnnotationData> getAllDispoAnnotations() {
        return this.dispoApi.getDispoAnnotations(this.branch, this.itemId);
    }

    @Path(value="resolutionType/{resolutionType}")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get all Annotations for a specific resolution Type for the DisposionableItem")
    @Tag(name="annotations")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Found Annotations"), @ApiResponse(responseCode="404", description="Not Found. Could not find any Annotations")})
    public Iterable<DispoAnnotationData> getAllDispoAnnotationsByType(@Parameter(description="The resolution type", required=true) @PathParam(value="resolutionType") String resolutionType) {
        List<DispoAnnotationData> annotationData = this.dispoApi.getDispoAnnotations(this.branch, this.itemId);
        return this.dispoApi.getDispoAnnotationsByType(annotationData, resolutionType);
    }

    @Path(value="{annotationId}")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a specific Annotation given an Id")
    @Tag(name="annotation")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Found Annotation"), @ApiResponse(responseCode="404", description="Not Found. Could not find the Annotation")})
    public DispoAnnotationData getAnnotationByIdJson(@Parameter(description="The Id of the Annotation to search for", required=true) @PathParam(value="annotationId") String annotationId) {
        return this.dispoApi.getDispoAnnotationById(this.branch, this.itemId, annotationId);
    }

    @Path(value="{annotationId}")
    @PUT
    @Consumes(value={"application/json"})
    @Operation(summary="Edit a specific Annotation given an Id and new Annotation Data")
    @Tags(value={@Tag(name="annotation"), @Tag(name="edit")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Annotation updated"), @ApiResponse(responseCode="404", description="Not Found. Could not find the Annotation")})
    public Response putDispoAnnotation(@Parameter(description="The Id of the Annotation to update", required=true) @PathParam(value="annotationId") String annotationId, DispoAnnotationData newAnnotation, @Parameter(description="The Username", required=true) @QueryParam(value="userName") String userName) {
        boolean wasEdited = this.dispoApi.editDispoAnnotation(this.branch, this.itemId, annotationId, newAnnotation, userName, false);
        Response response = wasEdited ? Response.status((Response.Status)Response.Status.OK).build() : Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        return response;
    }

    @Path(value="{annotationId}")
    @DELETE
    @Operation(summary="Delete a specific Annotation given an Id")
    @Tag(name="annotation")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found. Could not find the Annotation")})
    public Response deleteDispoAnnotation(@Parameter(description="The Id of the Annotation to delete", required=true) @PathParam(value="annotationId") String annotationId, @Parameter(description="The Username", required=true) @QueryParam(value="userName") String userName) {
        boolean wasEdited = this.dispoApi.deleteDispoAnnotation(this.branch, this.itemId, annotationId, userName, false);
        Response response = wasEdited ? Response.status((Response.Status)Response.Status.OK).build() : Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        return response;
    }
}

