/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.exceptionregistry;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class ExceptionRegistryEntry
implements ToMessage {
    String primary;
    String secondary;
    @JsonIgnore
    int hashCode;

    public ExceptionRegistryEntry() {
        this.primary = null;
        this.secondary = null;
        this.hashCode = 0;
    }

    public ExceptionRegistryEntry(String primary, String secondary) {
        this.primary = Objects.requireNonNull(primary, "ExceptionRegistryEntry::new, parameter \"primary\" cannot be null.");
        if (this.primary.isBlank()) {
            throw new IllegalArgumentException("ExceptionRegistryEntry::new, parameter \"primary\" cannot be blank.");
        }
        String string = this.secondary = Objects.nonNull(secondary) ? secondary : "(none)";
        if (this.secondary.isBlank()) {
            throw new IllegalArgumentException("ExceptionRegistryEntry::new, parameter \"secondary\" cannot be blank.");
        }
        this.setHash();
    }

    public boolean equals(Object other) {
        return other != null && other instanceof ExceptionRegistryEntry && this.hashCode == ((ExceptionRegistryEntry)other).hashCode && this.primary.equals(((ExceptionRegistryEntry)other).primary) && this.secondary.equals(((ExceptionRegistryEntry)other).secondary);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getPrimary() {
        if (Objects.isNull(this.primary)) {
            throw new IllegalStateException("ExceptionRegistryEntry::getPrimary, member \"primary\" has not been set.");
        }
        return this.primary;
    }

    public String getSecondary() {
        if (Objects.isNull(this.secondary)) {
            throw new IllegalStateException("ExceptionRegistryEntry::getSecondary, member \"secondary\" has not been set.");
        }
        return this.secondary;
    }

    public boolean isValid() {
        return Objects.nonNull(this.primary) && Objects.nonNull(this.secondary);
    }

    private void setHash() {
        this.hashCode = this.primary.hashCode() ^ this.secondary.hashCode() * 31;
    }

    public void setPrimary(String primary) {
        if (Objects.nonNull(this.primary)) {
            throw new IllegalStateException("ExceptionRegistryEntry::setPrimary, member \"primary\" has already been set.");
        }
        Objects.requireNonNull(primary, "ExceptionRegistryEntry::setPrimary, parameter \"primary\" cannot be null.");
        if (primary.isBlank()) {
            throw new IllegalArgumentException("ExceptionRegistryEntry::setPrimary, parameter \"primary\" cannot be blank.");
        }
        this.primary = primary;
        if (this.isValid()) {
            this.setHash();
        }
    }

    public void setSecondary(String secondary) {
        if (Objects.nonNull(this.secondary)) {
            throw new IllegalStateException("ExceptionRegistryEntry::setSecondary, member \"secondary\" has already been set.");
        }
        Objects.requireNonNull(this.primary, "ExceptionRegistryEntry::setSecondary, parameter \"primary\" cannot be null.");
        if (secondary.isBlank()) {
            throw new IllegalArgumentException("ExceptionRegistryEntry::setSecondary, parameter \"secondary\" cannot be blank.");
        }
        this.secondary = secondary;
        if (this.isValid()) {
            this.setHash();
        }
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Exception Registry Entry").indentInc().segment((CharSequence)"Primary Exception Name", (Object)this.primary).segment((CharSequence)"Secondary Exception Name", (Object)this.secondary).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

