/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.mim.MimArtifactsApi;
import org.eclipse.osee.mim.types.MimImportToken;
import org.eclipse.osee.mim.types.MimReportToken;
import org.eclipse.osee.orcs.OrcsApi;

public class MimArtifactsApiImpl
implements MimArtifactsApi {
    private final OrcsApi orcsApi;

    public MimArtifactsApiImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    @Override
    public List<MimReportToken> getMimReports() {
        LinkedList<MimReportToken> reports = new LinkedList<MimReportToken>();
        for (ArtifactReadable art : this.orcsApi.getQueryFactory().fromBranch(BranchId.valueOf((Long)CoreBranches.COMMON.getId())).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.MimReport}).asArtifacts()) {
            if (!art.isValid()) continue;
            reports.add(new MimReportToken(art));
        }
        return reports;
    }

    @Override
    public List<MimImportToken> getMimImports() {
        LinkedList<MimImportToken> importOptions = new LinkedList<MimImportToken>();
        for (ArtifactReadable art : this.orcsApi.getQueryFactory().fromBranch(BranchId.valueOf((Long)CoreBranches.COMMON.getId())).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.MimImport}).asArtifacts()) {
            if (!art.isValid()) continue;
            importOptions.add(new MimImportToken(art));
        }
        return importOptions;
    }
}

