/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.internal.InterfaceNodeAccessor;
import org.eclipse.osee.mim.types.ArtifactMatch;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.orcs.OrcsApi;

public class InterfaceNodeViewApiImpl
implements InterfaceNodeViewApi {
    private ArtifactAccessor<InterfaceNode> accessor;

    InterfaceNodeViewApiImpl(OrcsApi orcsApi) {
        this.setAccessor(new InterfaceNodeAccessor(orcsApi));
    }

    @Override
    public ArtifactAccessor<InterfaceNode> getAccessor() {
        return this.accessor;
    }

    public void setAccessor(ArtifactAccessor<InterfaceNode> accessor) {
        this.accessor = accessor;
    }

    @Override
    public Collection<InterfaceNode> query(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, false);
    }

    @Override
    public InterfaceNode get(BranchId branch, ArtifactId nodeId) {
        try {
            return this.getAccessor().get(branch, nodeId);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return InterfaceNode.SENTINEL;
        }
    }

    @Override
    public Collection<InterfaceNode> queryExact(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, true);
    }

    @Override
    public Collection<InterfaceNode> query(BranchId branch, MimAttributeQuery query, boolean isExact) {
        return this.query(branch, query, isExact, 0L, 0L);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedArtifacts(BranchId branch, ArtifactId relatedId) {
        try {
            return this.getAccessor().getAffectedArtifacts(branch, relatedId, new LinkedList<RelationTypeSide>());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<ArtifactMatch>();
        }
    }

    @Override
    public Collection<InterfaceNode> query(BranchId branch, MimAttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, false, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceNode> queryExact(BranchId branch, MimAttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, true, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceNode> query(BranchId branch, MimAttributeQuery query, boolean isExact, long pageNum, long pageSize) {
        try {
            return this.getAccessor().getAllByQuery(branch, query, isExact, pageNum, pageSize);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceNode>();
        }
    }

    @Override
    public Collection<InterfaceNode> getAll(BranchId branch) {
        return this.getAll(branch, 0L, 0L);
    }

    @Override
    public Collection<InterfaceNode> getAll(BranchId branch, long pageNum, long pageSize) {
        return this.getAll(branch, pageNum, pageSize, (AttributeTypeToken)AttributeTypeToken.SENTINEL);
    }

    @Override
    public Collection<InterfaceNode> getAll(BranchId branch, AttributeTypeToken orderByAttributeType) {
        return this.getAll(branch, 0L, 0L, orderByAttributeType);
    }

    @Override
    public Collection<InterfaceNode> getAll(BranchId branch, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        try {
            return this.getAccessor().getAll(branch, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceNode>();
        }
    }

    @Override
    public Collection<InterfaceNode> getMessagePublisherNodes(BranchId branch, ArtifactId message) {
        try {
            return this.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceMessagePubNode_Message, message);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceNode>();
        }
    }

    @Override
    public Collection<InterfaceNode> getMessageSubscriberNodes(BranchId branch, ArtifactId message) {
        try {
            return this.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceMessageSubNode_Message, message);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceNode>();
        }
    }

    @Override
    public Collection<InterfaceNode> getNodesForConnection(BranchId branch, ArtifactId connectionId) {
        try {
            return this.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceConnectionNode_Connection, connectionId);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceNode>();
        }
    }
}

