/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.orcs.OrcsApi;

public class ArtifactValidationCheckOperation {
    private final List<ArtifactReadable> itemsToCheck;
    private final boolean stopOnFirstError;
    private final XResultData results;

    public ArtifactValidationCheckOperation(OrcsApi orcsApi, XResultData results, ArtifactReadable parentArtifact, boolean stopOnFirstError) {
        this.stopOnFirstError = stopOnFirstError;
        this.itemsToCheck = new ArrayList<ArtifactReadable>();
        this.itemsToCheck.add(parentArtifact);
        this.results = results;
    }

    public boolean isStopOnFirstError() {
        return this.stopOnFirstError;
    }

    public XResultData validate() {
        for (ArtifactReadable artifact : this.itemsToCheck) {
            boolean hasError = this.validateArt(artifact, this.results);
            if (this.isStopOnFirstError() && hasError) break;
        }
        return this.results;
    }

    private boolean validateArt(ArtifactReadable artifact, XResultData results) {
        return false;
    }
}

