/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.reqifsynchronizationartifactbuilder;

import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.define.operations.synchronization.UnexpectedGroveThingTypeException;
import org.eclipse.osee.define.operations.synchronization.forest.GroveThing;
import org.eclipse.osee.define.operations.synchronization.forest.denizens.NativeDataType;
import org.eclipse.osee.define.operations.synchronization.forest.denizens.NativeDataTypeKey;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.reqifsynchronizationartifactbuilder.AttributeValueConverter;
import org.eclipse.osee.define.operations.synchronization.reqifsynchronizationartifactbuilder.ReqIFSynchronizationArtifactBuilder;
import org.eclipse.osee.define.util.DataConverters;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeBoolean;
import org.eclipse.osee.framework.core.data.AttributeTypeBranchId;
import org.eclipse.osee.framework.core.data.AttributeTypeDate;
import org.eclipse.osee.framework.core.data.AttributeTypeDouble;
import org.eclipse.osee.framework.core.data.AttributeTypeInteger;
import org.eclipse.osee.framework.core.data.AttributeTypeLong;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.EnumBiConsumerMap;
import org.eclipse.osee.framework.jdk.core.util.EnumSupplierMap;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeDefinitionDate;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValueBoolean;
import org.eclipse.rmf.reqif10.AttributeValueDate;
import org.eclipse.rmf.reqif10.AttributeValueInteger;
import org.eclipse.rmf.reqif10.AttributeValueReal;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.XhtmlContent;

public class AttributeDefinitionConverter {
    private static final EnumBiConsumerMap<NativeDataType, GroveThing, AttributeDefinition> reqifAttributeDefinitionDatatypeConverterMap = EnumBiConsumerMap.ofEntries(NativeDataType.class, (Map.Entry[])new Map.Entry[]{Map.entry(NativeDataType.ARTIFACT_IDENTIFIER, AttributeDefinitionConverter::convertAttributeDefinitionReqIfAttributeDefinitionIntegerForArtifactId), Map.entry(NativeDataType.BRANCH_IDENTIFIER, AttributeDefinitionConverter::convertAttributeDefinitionReqIfAttributeDefinitionIntegerForBranchId), Map.entry(NativeDataType.BOOLEAN, AttributeDefinitionConverter::convertAttributeDefinitionReqIfAttributeDefinitionBoolean), Map.entry(NativeDataType.DATE, AttributeDefinitionConverter::convertAttributeDefinitionReqIfAttributeDefinitionDate), Map.entry(NativeDataType.DOUBLE, AttributeDefinitionConverter::convertAttributeDefinitionReqIfAttributeDefinitionDouble), Map.entry(NativeDataType.INTEGER, AttributeDefinitionConverter::convertAttributeDefinitionReqIfAttributeDefinitionIntegerForInteger), Map.entry(NativeDataType.LONG, AttributeDefinitionConverter::convertAttributeDefinitionReqIfAttributeDefinitionIntegerForLong), Map.entry(NativeDataType.STRING, AttributeDefinitionConverter::convertAttributeDefinitionReqIfAttributeDefinitionString), Map.entry(NativeDataType.STRING_WORD_ML, AttributeDefinitionConverter::convertAttributeDefinitionReqIfAttributeDefinitionXHTML), Map.entry(NativeDataType.URI, AttributeDefinitionConverter::convertAttributeDefinitionReqIfAttributeDefinitionString)});
    private static final EnumSupplierMap<NativeDataType, AttributeDefinition> reqifAttributeDefinitionFactoryMap;

    static {
        Map.Entry[] entryArray = new Map.Entry[13];
        entryArray[0] = Map.entry(NativeDataType.ARTIFACT_IDENTIFIER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionInteger());
        entryArray[1] = Map.entry(NativeDataType.BRANCH_IDENTIFIER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionInteger());
        entryArray[2] = Map.entry(NativeDataType.BOOLEAN, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionBoolean());
        entryArray[3] = Map.entry(NativeDataType.DATE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionDate());
        entryArray[4] = Map.entry(NativeDataType.DOUBLE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionReal());
        entryArray[5] = Map.entry(NativeDataType.ENUMERATED, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionEnumeration());
        entryArray[6] = Map.entry(NativeDataType.INPUT_STREAM, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionString());
        entryArray[7] = Map.entry(NativeDataType.INTEGER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionInteger());
        entryArray[8] = Map.entry(NativeDataType.JAVA_OBJECT, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionString());
        entryArray[9] = Map.entry(NativeDataType.LONG, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionInteger());
        entryArray[10] = Map.entry(NativeDataType.STRING, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionString());
        entryArray[11] = Map.entry(NativeDataType.STRING_WORD_ML, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionXHTML());
        entryArray[12] = Map.entry(NativeDataType.URI, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionString());
        reqifAttributeDefinitionFactoryMap = EnumSupplierMap.ofEntries(NativeDataType.class, (Map.Entry[])entryArray);
    }

    private AttributeDefinitionConverter() {
    }

    static void convert(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing.isType(IdentifierType.ATTRIBUTE_DEFINITION)) : UnexpectedGroveThingTypeException.buildMessage(groveThing, IdentifierType.ATTRIBUTE_DEFINITION);
        GroveThing datatypeDefinition = groveThing.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
        NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinition.getNativeThing()).getNativeDataType();
        AttributeDefinition reqifAttributeDefinition = (AttributeDefinition)reqifAttributeDefinitionFactoryMap.get((Enum)nativeDataType);
        AttributeDefinitionConverter.convertAttributeDefinitionReqIfAttributeDefinition(groveThing, reqifAttributeDefinition);
        if (reqifAttributeDefinitionDatatypeConverterMap.containsKey((Enum)nativeDataType)) {
            reqifAttributeDefinitionDatatypeConverterMap.accept((Enum)nativeDataType, (Object)groveThing, (Object)reqifAttributeDefinition);
        }
        groveThing.setForeignThing(reqifAttributeDefinition);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinition(GroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        String description = nativeAttributeTypeToken.getDescription();
        if (description == null || description.isEmpty()) {
            description = new StringBuilder(512).append("OSEE ").append(nativeAttributeTypeToken.getName()).append(" Attribute Definition").toString();
        }
        reqifAttributeDefinition.setDesc(description);
        reqifAttributeDefinition.setIdentifier(attributeDefinitionGroveThing.getIdentifier().toString());
        reqifAttributeDefinition.setLastChange(ReqIFSynchronizationArtifactBuilder.lastChangeEpoch);
        reqifAttributeDefinition.setLongName(nativeAttributeTypeToken.getName());
        reqifAttributeDefinition.setEditable(!nativeAttributeTypeToken.notEditable());
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionBoolean(GroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeBoolean);
        AttributeTypeBoolean nativeAttributeTypeBoolean = (AttributeTypeBoolean)nativeAttributeTypeToken;
        Boolean defaultValue = (Boolean)nativeAttributeTypeBoolean.getBaseAttributeTypeDefaultValue();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionBoolean);
        AttributeDefinitionBoolean reqifAttributeDefinitionBoolean = (AttributeDefinitionBoolean)reqifAttributeDefinition;
        GroveThing datatypeDefinition = attributeDefinitionGroveThing.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
        NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinition.getNativeThing()).getNativeDataType();
        assert (nativeDataType.equals((Object)NativeDataType.BOOLEAN));
        AttributeValueBoolean defaultAttributeValue = (AttributeValueBoolean)AttributeValueConverter.reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(defaultValue.booleanValue());
        reqifAttributeDefinitionBoolean.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionDate(GroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeDate);
        AttributeTypeDate nativeAttributeTypeDate = (AttributeTypeDate)nativeAttributeTypeToken;
        Date defaultValue = (Date)nativeAttributeTypeDate.getBaseAttributeTypeDefaultValue();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionDate);
        AttributeDefinitionDate reqifAttributeDefinitionDate = (AttributeDefinitionDate)reqifAttributeDefinition;
        GroveThing datatypeDefinition = attributeDefinitionGroveThing.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
        NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinition.getNativeThing()).getNativeDataType();
        assert (nativeDataType.equals((Object)NativeDataType.DATE));
        AttributeValueDate defaultAttributeValue = (AttributeValueDate)AttributeValueConverter.reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(DataConverters.dateToGregorianCalendar(defaultValue));
        reqifAttributeDefinitionDate.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionDouble(GroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeDouble);
        AttributeTypeDouble nativeAttributeTypeDouble = (AttributeTypeDouble)nativeAttributeTypeToken;
        Double defaultValue = (Double)nativeAttributeTypeDouble.getBaseAttributeTypeDefaultValue();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionReal);
        AttributeDefinitionReal reqifAttributeDefinitionReal = (AttributeDefinitionReal)reqifAttributeDefinition;
        GroveThing datatypeDefinition = attributeDefinitionGroveThing.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
        NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinition.getNativeThing()).getNativeDataType();
        assert (nativeDataType.equals((Object)NativeDataType.DOUBLE));
        AttributeValueReal defaultAttributeValue = (AttributeValueReal)AttributeValueConverter.reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(defaultValue.doubleValue());
        reqifAttributeDefinitionReal.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionIntegerForArtifactId(GroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeArtifactId);
        AttributeTypeArtifactId nativeAttributeTypeArtifactId = (AttributeTypeArtifactId)nativeAttributeTypeToken;
        Long defaultValue = ((ArtifactId)nativeAttributeTypeArtifactId.getBaseAttributeTypeDefaultValue()).getId();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionInteger);
        AttributeDefinitionInteger reqifAttributeDefinitionInteger = (AttributeDefinitionInteger)reqifAttributeDefinition;
        GroveThing datatypeDefinition = attributeDefinitionGroveThing.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
        NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinition.getNativeThing()).getNativeDataType();
        assert (nativeDataType.equals((Object)NativeDataType.ARTIFACT_IDENTIFIER));
        AttributeValueInteger defaultAttributeValue = (AttributeValueInteger)AttributeValueConverter.reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(BigInteger.valueOf(defaultValue));
        reqifAttributeDefinitionInteger.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionIntegerForBranchId(GroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeBranchId);
        AttributeTypeBranchId nativeAttributeTypeBranchId = (AttributeTypeBranchId)nativeAttributeTypeToken;
        Long defaultValue = ((BranchId)nativeAttributeTypeBranchId.getBaseAttributeTypeDefaultValue()).getId();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionInteger);
        AttributeDefinitionInteger reqifAttributeDefinitionInteger = (AttributeDefinitionInteger)reqifAttributeDefinition;
        GroveThing datatypeDefinition = attributeDefinitionGroveThing.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
        NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinition.getNativeThing()).getNativeDataType();
        assert (nativeDataType.equals((Object)NativeDataType.ARTIFACT_IDENTIFIER));
        AttributeValueInteger defaultAttributeValue = (AttributeValueInteger)AttributeValueConverter.reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(BigInteger.valueOf(defaultValue));
        reqifAttributeDefinitionInteger.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionIntegerForInteger(GroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeInteger);
        AttributeTypeInteger nativeAttributeTypeInteger = (AttributeTypeInteger)nativeAttributeTypeToken;
        Integer defaultValue = (Integer)nativeAttributeTypeInteger.getBaseAttributeTypeDefaultValue();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionInteger);
        AttributeDefinitionInteger reqifAttributeDefinitionInteger = (AttributeDefinitionInteger)reqifAttributeDefinition;
        GroveThing datatypeDefinition = attributeDefinitionGroveThing.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
        NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinition.getNativeThing()).getNativeDataType();
        assert (nativeDataType.equals((Object)NativeDataType.INTEGER));
        AttributeValueInteger defaultAttributeValue = (AttributeValueInteger)AttributeValueConverter.reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(BigInteger.valueOf(defaultValue.intValue()));
        reqifAttributeDefinitionInteger.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionIntegerForLong(GroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeLong);
        AttributeTypeLong nativeAttributeTypeLong = (AttributeTypeLong)nativeAttributeTypeToken;
        Long defaultValue = (Long)nativeAttributeTypeLong.getBaseAttributeTypeDefaultValue();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionInteger);
        AttributeDefinitionInteger reqifAttributeDefinitionInteger = (AttributeDefinitionInteger)reqifAttributeDefinition;
        GroveThing datatypeDefinition = attributeDefinitionGroveThing.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
        NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinition.getNativeThing()).getNativeDataType();
        assert (nativeDataType.equals((Object)NativeDataType.LONG));
        AttributeValueInteger defaultAttributeValue = (AttributeValueInteger)AttributeValueConverter.reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(BigInteger.valueOf(defaultValue));
        reqifAttributeDefinitionInteger.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionString(GroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeString) : "Actual Type: " + nativeAttributeTypeToken.getClass().getName();
        AttributeTypeString nativeAttributeTypeString = (AttributeTypeString)nativeAttributeTypeToken;
        String defaultValue = (String)nativeAttributeTypeString.getBaseAttributeTypeDefaultValue();
        if (defaultValue.isEmpty()) {
            return;
        }
        assert (reqifAttributeDefinition instanceof AttributeDefinitionString);
        AttributeDefinitionString reqifAttributeDefinitionString = (AttributeDefinitionString)reqifAttributeDefinition;
        GroveThing datatypeDefinition = attributeDefinitionGroveThing.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
        NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinition.getNativeThing()).getNativeDataType();
        AttributeValueString defaultAttributeValue = (AttributeValueString)AttributeValueConverter.reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(defaultValue);
        reqifAttributeDefinitionString.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionXHTML(GroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeString) : "Actual Type: " + nativeAttributeTypeToken.getClass().getName();
        AttributeTypeString nativeAttributeTypeString = (AttributeTypeString)nativeAttributeTypeToken;
        String defaultValue = (String)nativeAttributeTypeString.getBaseAttributeTypeDefaultValue();
        if (defaultValue.isEmpty()) {
            return;
        }
        assert (reqifAttributeDefinition instanceof AttributeDefinitionXHTML);
        AttributeDefinitionXHTML reqifAttributeDefinitionXHTML = (AttributeDefinitionXHTML)reqifAttributeDefinition;
        GroveThing datatypeDefinition = attributeDefinitionGroveThing.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get();
        NativeDataType nativeDataType = ((NativeDataTypeKey)datatypeDefinition.getNativeThing()).getNativeDataType();
        AttributeValueXHTML defaultAttributeValue = (AttributeValueXHTML)AttributeValueConverter.reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        XhtmlContent xhtmlContent = DataConverters.wordMlStringToXhtmlContent(defaultValue);
        defaultAttributeValue.setTheValue(xhtmlContent);
        reqifAttributeDefinitionXHTML.setDefaultValue(defaultAttributeValue);
    }
}

