/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.publishingdom;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierFactory;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierFactoryType;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTypeGroup;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AbstractHierarchicalNode;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AttributeDefinitionImpl;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AttributeValueImpl;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentMap;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentObject;
import org.eclipse.osee.define.operations.synchronization.publishingdom.Node;

class DocumentObjectImpl
extends AbstractHierarchicalNode
implements DocumentObject {
    private final Map<String, AttributeDefinitionImpl> attributeDefinitionByAttributeDefinitionNameMap;
    private final String name;
    private final String typeDescription;

    DocumentObjectImpl(DocumentMap documentMap, Identifier identifier, String name, String typeDescription) {
        super(documentMap, identifier);
        assert (identifier.isInGroup(IdentifierTypeGroup.SUBORDINATE_OBJECT)) : "DocumentObjectImpl::new, parameter \"identifier\" is not of the type \"IdentifierType.SPEC_OBJECT\", \"Identifier.SPECTER_SPEC_OBJECT\", or \"Identifier.SPEC_RELATION\".";
        assert (Objects.nonNull(name)) : "DocumentObjectImpl::new, parameter \"name\" cannot be null.";
        assert (Objects.nonNull(typeDescription)) : "DocumentObjectImpl::new, parameter \"typeDescription\" cannot be null.";
        this.name = name;
        this.typeDescription = typeDescription;
        this.attributeDefinitionByAttributeDefinitionNameMap = new HashMap<String, AttributeDefinitionImpl>();
    }

    @Override
    void append(Node childNode) {
        super.append(childNode);
        assert (childNode.getIdentifier().isInGroup(IdentifierTypeGroup.SUBORDINATE_OBJECT)) : "DocumentObjectImpl::append, parameter \"childNode\" is not of the type \"IdentifierType.SPEC_OBJECT\", \"Identifier.SPECTER_SPEC_OBJECT\", or \"Identifier.SPEC_RELATION\".";
        if (!(childNode instanceof AttributeDefinitionImpl)) {
            return;
        }
        AttributeDefinitionImpl attributeDefinition = (AttributeDefinitionImpl)childNode;
        this.attributeDefinitionByAttributeDefinitionNameMap.put(attributeDefinition.getName(), attributeDefinition);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeDescription() {
        return this.typeDescription;
    }

    @Override
    public Optional<String> getPrimaryAttributeValue() {
        AttributeDefinitionImpl primaryAttributeDefinition = this.attributeDefinitionByAttributeDefinitionNameMap.get("Primary Attribute");
        if (Objects.isNull(primaryAttributeDefinition)) {
            return Optional.empty();
        }
        Identifier primaryAttributeDefinitionIdentifier = primaryAttributeDefinition.getIdentifier();
        if (this.attributeValueMap.size(new Object[]{primaryAttributeDefinitionIdentifier}) != 1) {
            return Optional.empty();
        }
        IdentifierFactory identifierFactory = new IdentifierFactory(IdentifierFactoryType.PATTERN_MATCHING);
        AttributeValueImpl attributeValue = (AttributeValueImpl)this.attributeValueMap.get((Object[])this.attributeValueMap.streamKeySets(new Object[]{primaryAttributeDefinitionIdentifier}).findFirst().get()).get();
        String identifierString = attributeValue.getValue();
        Identifier identifier = identifierFactory.createIdentifier(IdentifierType.ATTRIBUTE_DEFINITION, identifierString);
        AttributeDefinitionImpl thePrimaryAttributeDefinition = (AttributeDefinitionImpl)this.attributeDefinitionMap.get(identifier);
        if (Objects.isNull(thePrimaryAttributeDefinition)) {
            return Optional.empty();
        }
        Identifier thePrimaryAttributeDefinitionIdentifier = thePrimaryAttributeDefinition.getIdentifier();
        if (this.attributeValueMap.size(new Object[]{thePrimaryAttributeDefinitionIdentifier}) != 1) {
            return Optional.empty();
        }
        AttributeValueImpl thePrimaryAttributeValue = (AttributeValueImpl)this.attributeValueMap.get((Object[])this.attributeValueMap.streamKeySets(new Object[]{thePrimaryAttributeDefinitionIdentifier}).findFirst().get()).get();
        String value = thePrimaryAttributeValue.getValue();
        return Optional.of(value);
    }

    @Override
    public Optional<String> getNameAttributeValue() {
        AttributeDefinitionImpl nameAttributeDefinition = this.attributeDefinitionByAttributeDefinitionNameMap.get("Name");
        if (Objects.isNull(nameAttributeDefinition)) {
            return Optional.empty();
        }
        Identifier nameAttributeDefinitionIdentifier = nameAttributeDefinition.getIdentifier();
        if (this.attributeValueMap.size(new Object[]{nameAttributeDefinitionIdentifier}) != 1) {
            return Optional.empty();
        }
        AttributeValueImpl nameAttributeValue = (AttributeValueImpl)this.attributeValueMap.get((Object[])this.attributeValueMap.streamKeySets(new Object[]{nameAttributeDefinitionIdentifier}).findFirst().get()).get();
        String value = nameAttributeValue.getValue();
        return Optional.of(value);
    }
}

