/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.forest.denizens;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.define.operations.synchronization.forest.denizens.NativeDataType;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class NativeDataTypeKey {
    NativeDataType nativeDataType;
    AttributeTypeToken nativeAttributeTypeToken;

    NativeDataTypeKey(NativeDataType nativeDataType) {
        Objects.requireNonNull(nativeDataType);
        if (nativeDataType.equals((Object)NativeDataType.ENUMERATED)) {
            throw new IllegalArgumentException();
        }
        this.nativeDataType = nativeDataType;
        this.nativeAttributeTypeToken = null;
    }

    NativeDataTypeKey(AttributeTypeToken attributeTypeToken) {
        Objects.requireNonNull(attributeTypeToken);
        if (!attributeTypeToken.isEnumerated()) {
            throw new IllegalArgumentException();
        }
        this.nativeDataType = NativeDataType.ENUMERATED;
        this.nativeAttributeTypeToken = attributeTypeToken;
    }

    public NativeDataType getNativeDataType() {
        return this.nativeDataType;
    }

    public Optional<AttributeTypeToken> getNativeAttributeTypeToken() {
        return Optional.ofNullable(this.nativeAttributeTypeToken);
    }

    public int hashCode() {
        return this.nativeDataType == NativeDataType.ENUMERATED ? this.nativeAttributeTypeToken.getId().hashCode() : this.nativeDataType.hashCode();
    }

    public boolean isEnumerated() {
        return this.nativeDataType.equals((Object)NativeDataType.ENUMERATED);
    }

    public boolean equals(Object other) {
        return other != null && other instanceof NativeDataTypeKey && this.nativeDataType == ((NativeDataTypeKey)other).nativeDataType ? (this.nativeDataType == NativeDataType.ENUMERATED ? this.nativeAttributeTypeToken.equals(((NativeDataTypeKey)other).nativeAttributeTypeToken) : true) : false;
    }

    public String name() {
        return this.isEnumerated() ? new StringBuilder(1024).append(this.nativeDataType.name()).append("-").append(this.nativeAttributeTypeToken.getIdString()).toString() : this.nativeDataType.name();
    }
}

