/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.osee.define.rest.internal.wordupdate.UpdateBookmarkIds;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WordCoreUtilServer {
    public static final String CHANGE_TAG = "[*] ";
    public static final String CHANGE_TAG_WORDML = "<w:r><w:rPr><w:color w:val=\"#FF0000\"/></w:rPr><w:t>[*] </w:t></w:r>";
    public static final String LISTNUM_FIELD_HEAD = "<w:pPr><w:rPr><w:vanish/></w:rPr></w:pPr>";
    public static final String BODY_START = "<w:body>";
    public static final String BODY_END = "</w:body>";
    private static final Pattern binIdPattern = Pattern.compile("wordml://(.+?)[.]");
    private static final Pattern paragraphPattern = Pattern.compile("<w:p( .*?)?>");
    private static final Pattern referencePattern = Pattern.compile("(_Ref[0-9]{9}|Word\\.Bookmark\\.End)");
    private static int bookMarkId = 1000;
    private static UpdateBookmarkIds updateBookmarkIds = new UpdateBookmarkIds(bookMarkId);
    private static String newLineChar = ">(\\r|\\n|\\r\\n)<";

    public static byte[] getFormattedContent(Element formattedItemElement) throws XMLStreamException {
        ByteArrayOutputStream data = new ByteArrayOutputStream(1024);
        XMLStreamWriter xmlWriter = null;
        try {
            xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(data, "UTF-8");
            for (Element e : Jaxp.getChildDirects((Element)formattedItemElement)) {
                Jaxp.writeNode((XMLStreamWriter)xmlWriter, (Node)e, (boolean)false);
            }
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.flush();
                xmlWriter.close();
            }
        }
        return data.toByteArray();
    }

    public static WordCoreUtil.pageType getPageOrientation(ArtifactReadable artifactReadable) {
        WordCoreUtil.pageType defaultPageType = WordCoreUtil.pageType.getDefault();
        if (artifactReadable.isInvalid()) {
            return defaultPageType;
        }
        if (!artifactReadable.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.PageOrientation)) {
            return defaultPageType;
        }
        try {
            String pageTypeString = artifactReadable.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.PageOrientation, defaultPageType.name());
            return WordCoreUtil.pageType.fromString((String)pageTypeString);
        }
        catch (Exception exception) {
            return defaultPageType;
        }
    }

    public static String referencesOnly(String content) {
        ArrayList<String> references = new ArrayList<String>();
        Matcher referenceMatcher = referencePattern.matcher(content);
        while (referenceMatcher.find()) {
            String reference = referenceMatcher.group(1);
            references.add(reference);
        }
        StringBuilder sb = new StringBuilder();
        for (String reference : references) {
            sb.append(reference);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static boolean isHeadingStyle(String paragraphStyle) {
        if (paragraphStyle == null) {
            return false;
        }
        String style = paragraphStyle.toLowerCase();
        return style.startsWith("heading") || style.startsWith("toc") || style.startsWith("outline");
    }

    public static String reassignBinDataID(String content) {
        ChangeSet changeSet = new ChangeSet((CharSequence)content);
        HashMap<String, String> guidMap = new HashMap<String, String>();
        Matcher binIdMatcher = binIdPattern.matcher(content);
        boolean atLeastOneMatch = false;
        while (binIdMatcher.find()) {
            atLeastOneMatch = true;
            String oldName = binIdMatcher.group(1);
            String guid = (String)guidMap.get(oldName);
            if (guid == null) {
                guid = GUID.create();
                guidMap.put(oldName, guid);
            }
            changeSet.replace(binIdMatcher.start(1), binIdMatcher.end(1), guid);
        }
        if (atLeastOneMatch) {
            return changeSet.toString();
        }
        return content;
    }

    public static CharSequence reassignBookMarkID(CharSequence content) {
        return updateBookmarkIds.fixTags(content);
    }

    public static String removeNewLines(String content) {
        return content.replaceAll(newLineChar, "><");
    }

    public static String appendInlineChangeTag(String content) {
        Matcher paragraphMatcher = paragraphPattern.matcher(content);
        if (paragraphMatcher.find()) {
            StringBuilder strB = new StringBuilder();
            strB.append(content.substring(0, paragraphMatcher.end()));
            strB.append(CHANGE_TAG_WORDML);
            strB.append(content.substring(paragraphMatcher.end(), content.length()));
            content = strB.toString();
        }
        return content;
    }
}

