/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.util;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.core.column.ChangeTypeColumn;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;

public class CopyActionDetails {
    private final IAtsWorkItem workItem;
    private static final String USE_DEVELOPER_CHANGE_TYPES = "UseDeveloperChangeTypes";
    private final AtsApi atsApi;

    public CopyActionDetails(IAtsWorkItem workItem, AtsApi atsApi) {
        this.workItem = workItem;
        this.atsApi = atsApi;
    }

    public String getDetailsString() {
        String detailsStr = "";
        try {
            IAtsTeamDefinition teamDef;
            String formatStr;
            for (IAtsWorkItemHook workItemHook : this.atsApi.getWorkItemService().getWorkItemHooks()) {
                detailsStr = workItemHook.getCopyActionDetails(this.workItem);
                if (Strings.isValid((String)detailsStr)) break;
            }
            if (Strings.isInValid((String)detailsStr) && this.workItem.getParentTeamWorkflow() != null && Strings.isValid((String)(formatStr = this.getFormatStr(teamDef = this.workItem.getParentTeamWorkflow().getTeamDefinition())))) {
                String legacyPcrId;
                detailsStr = formatStr;
                IAtsAction action = this.workItem.getParentAction();
                if (action != null) {
                    detailsStr = detailsStr.replaceAll("<actionatsid>", action.getAtsId());
                }
                detailsStr = Strings.isValid((String)(legacyPcrId = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.LegacyPcrId, null))) ? detailsStr.replaceAll("<legacypcrid>", " - [" + legacyPcrId + "]") : detailsStr.replaceAll("<legacypcrid>", "");
                detailsStr = detailsStr.replaceAll("<atsid>", this.workItem.getAtsId());
                detailsStr = detailsStr.replaceAll("<name>", this.workItem.getName());
                detailsStr = detailsStr.replaceAll("<artType>", this.workItem.getArtifactTypeName());
                detailsStr = detailsStr.replaceAll("<changeType>", this.getChangeTypeOrObjectType(this.workItem));
            }
            if (Strings.isInValid((String)detailsStr)) {
                detailsStr = "\"" + this.workItem.getArtifactTypeName() + "\" - " + this.workItem.getAtsId() + " - \"" + this.workItem.getName() + "\"";
            }
        }
        catch (Exception ex) {
            OseeLog.log(CopyActionDetails.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return detailsStr;
    }

    private String getChangeTypeOrObjectType(IAtsWorkItem workItem) {
        String result = "";
        if (workItem instanceof IAtsTeamWorkflow) {
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
            result = ChangeTypeColumn.getChangeTypeStr(workItem, this.atsApi);
            if (teamWf.getTeamDefinition().hasTag(USE_DEVELOPER_CHANGE_TYPES)) {
                if (result.equals("Improvement")) {
                    result = "feature";
                } else if (result.equals("Problem")) {
                    result = "bug";
                } else if (result.equals("Refinement")) {
                    result = "refinement";
                }
            }
        } else if (workItem instanceof IAtsTask) {
            result = "Task";
        } else if (workItem.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractReview})) {
            result = "Review";
        } else if (workItem.isTypeEqual((ArtifactTypeId)AtsArtifactTypes.Goal)) {
            result = "Goal";
        } else if (workItem.isTypeEqual((ArtifactTypeId)AtsArtifactTypes.AgileBacklog)) {
            result = "Backlog";
        }
        if (!Strings.isValid((String)result)) {
            result = "unknown";
        }
        return result;
    }

    private String getFormatStr(IAtsTeamDefinition teamDef) {
        if (teamDef != null) {
            String formatStr;
            ArtifactToken artifact = this.atsApi.getQueryService().getArtifact((IAtsObject)teamDef);
            if (artifact != null && Strings.isValid((String)(formatStr = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)artifact, (AttributeTypeToken)AtsAttributeTypes.ActionDetailsFormat, (Object)"")))) {
                return formatStr;
            }
            if (this.atsApi.getTeamDefinitionService().getParentTeamDef(teamDef) != null) {
                return this.getFormatStr((IAtsTeamDefinition)this.atsApi.getTeamDefinitionService().getParentTeamDef(teamDef));
            }
        }
        return null;
    }
}

